//
//  UINavigationBar+Helper.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 09.02.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

extension UINavigationBar {
  func setBottomBorderColor(color: UIColor, height: CGFloat) {
    if let index = self.subviews.indexOf({$0.tag == -77}) {
      self.subviews[index].removeFromSuperview()
    }
    let bottomBorderRect = CGRect(x: 0, y: CGRectGetHeight(self.frame), width: CGRectGetWidth(self.frame), height: height);
    let bottomBorder = UIView(frame: bottomBorderRect)
    bottomBorder.backgroundColor = color
    self.addSubview(bottomBorder)
    bottomBorder.tag = -77
  }
}
