//
//  UIConsts.swift
//  kt
//
//  Created by Alexandr Zalutskiy on 19.01.15.
//  Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import UIKit

// MARK: Fonts

let NavigationBarFont = UIFont(name: "PTSans-Bold", size: 17.0)

// MARK: Colors

// MARK: Controllers

struct Notification {
    static let loginModalClosed = "loginVCClosed"
    static let appDidBecomeActive = "AppDidBecomeActive"
}

let MenuControllerId = "MenuTableController"

let HomeControllerId = "HomeNavigationController"
let ServiceControllerId = "ServiceNavigationController"
let FeedbackControllerId = "FeedbackNavigationController"
let SettingsControllerId = "SettingsNavigationController"
let WiFiControllerId = "WiFiNavigationController"
let PssControllerId = "PssNavigationController"
let CabinetControllerId = "CabinetNavigationController"
let BlankControllerId = "BlankNavigationController"
let IdPhoneControllerId = "IDPhoneNavigationController"
let FastPayControllerId = "FastPayNavigationController"
let HomeContentControllerId = "HomeContentController"
let ServiceItemContentControllerId = "ServiceItemContentControllerId"
let ServicesPaymentNavigationControllerId = "ServicesPaymentNavigationController"
let MainControllerId = "MainViewController"
let MainServiceControllerId = "ServiceMainViewController"
let OfferControllerId = "OfferFormViewController"
let SoftwareControllerId = "SoftwareRentViewController"
let ClaimControllerId = "ClaimPageMenuViewController"
let BotControllerId = "BotViewController"

let BannerItemControllerId = "BannerItemController"

struct Segue {
    static let ShowServiceItemSegue = "ShowServiceItemSegue"
    static let ShowTariffSegue = "ShowTariffSegue"
    static let ShowCallBackSegue = "ShowCallBackSegue"
    static let ShowServiceDetails = "ShowServiceDetails"
    static let ConnectSegue = "connect"
    static let CallbackSegue = "callback"
    static let FullDamageModal = "full_damage_modal"
}

struct Color {
    
    static let ServicesPaymentButtonTextColor = UIColor(red: 172/255, green: 194/255, blue: 222/255, alpha: 1)
    static let PromoBlueColor = KTDefaultBlueColor//UIColor(red: 0/255, green: 106/255, blue: 184/255, alpha: 1)
    static let TextFieldUnderline = UIColor(red: 0xefp-8, green: 0xefp-8, blue: 0xf4p-8, alpha: 1.0)
    static let BlueColorForHighlighted = UIColor(red: 0.1, green: 0.46, blue: 0.73, alpha: 1.0)
    static let DarkColorForText = UIColor(red: 0.24, green: 0.27, blue: 0.3, alpha: 1.0)
    static let WhiteGreenColor = UIColor(red: 113/255, green: 216/255, blue: 122/255, alpha: 1)
    static let DarkGreenColor = UIColor(red: 78/255, green: 198/255, blue: 89/255, alpha: 1)
    static let BlueButtonHightlightedColor = ButtonBlueHighlightedColor//UIColor(red: 0.404, green: 0.718, blue: 0.961, alpha: 1.0)
    static let BlueButtonColor = ButtonBlueDefaultColor//UIColor(red: 32/255, green: 97/255, blue: 158/255, alpha: 1.0)
    static let NextButtonNormalColor = UIColor(red: 57/255, green: 119/255, blue: 175/255, alpha: 1)
    static let NextButtonHighlightedColor = UIColor(red: 112/255, green: 173/255, blue: 210/255, alpha: 1)
    static let CancelButtonNormalColor = UIColor(red: 82/255, green: 98/255, blue: 119/255, alpha: 1)
    static let CancelButtonHighlightedColor = UIColor(red: 105/255, green: 137/255, blue: 176/255, alpha: 1)
    static let HelpButtonNormalColor = UIColor(red: 82/255, green: 98/255, blue: 119/255, alpha: 1)
    static let HelpButtonHighlightedColor = UIColor(red: 2/255, green: 123/255, blue: 255/255, alpha: 1)
    static let GreyTextFieldBorderColor = UIColor(red: 225/255, green: 224/255, blue: 220/255, alpha: 1).CGColor
    static let GreyBackButtonColor = UIColor(red: 218/255, green: 216/255, blue: 210/255, alpha: 1)
    static let MenuTableBackgroundColor = UIColor(red: 32/255, green: 97/255, blue: 158/255, alpha: 1.0)
    static let ButtonClickedDefaultColor = UIColor(red: 224/255, green: 224/255, blue: 224/255, alpha: 1.0)
    static let ButtonGrayColor = UIColor(red: 117/255, green: 121/255, blue: 125/255, alpha: 1)
    static let DashboardBlueColor = KTDefaultBlueColor//UIColor(red: 0/255, green: 108/255, blue: 180/255, alpha: 1)
    static let DividerLightBlueColor = UIColor(red: 0/255, green: 113/255, blue: 181/255, alpha: 1)
    static let DividerDarkBlueColor = UIColor(red: 1/255, green: 105/255, blue: 183/255, alpha: 1)
    static let AuthBlueNormalColor = ButtonBlueDefaultColor//UIColor(red: 31/255, green: 132/255, blue: 212/255, alpha: 1)
    static let AuthBlueHighlightedColor = ButtonBlueHighlightedColor//UIColor(red: 103/255, green: 183/255, blue: 245/255, alpha: 1)
    static let AuthGrayNormalColor = ButtonGrayDefaultColor//UIColor(red: 84/255, green: 106/255, blue: 134/255, alpha: 1)
    static let AuthGrayHighlightedColor = ButtonGrayHighlightedColor//UIColor(red: 108/255, green: 146/255, blue: 194/255, alpha: 1)
    static let TitleBlackColor = UIColor(red: 60/255, green: 69/255, blue: 78/255, alpha: 1)
    static let PlaceholderGrayColor = UIColor(red: 200/255, green: 203/255, blue: 206/255, alpha: 1)
    static let ActionSheetItemHighlightedColor = UIColor(red: 235/255, green: 235/255, blue: 235/255, alpha: 1)
    static let ActionSheetTitleGrayColor = UIColor(red: 120/255, green: 135/255, blue: 155/255, alpha: 1)
    static let MyServicesCellGrayColor = UIColor(red: 142/255, green: 142/255, blue: 147/255, alpha: 1)
    static let ServicePaymentAllProvidersBlueColor = UIColor(red: 84/255, green: 106/255, blue: 134/255, alpha: 1)
    static let GrayNavbarColor = UIColor(red: 248/255, green: 248/255, blue: 248/255, alpha: 1)
    static let GrayTableCellSeparator = UIColor(red: 227/255, green: 227/255, blue: 229/255, alpha: 1)
    static let ErrorColor = UIColor(red: 186/255, green: 0/255, blue: 0/255, alpha: 1)
    static let SuccessColor = UIColor(red: 0/255, green: 186/255, blue: 0/255, alpha: 1)
    
    static let KTDefaultBlueColor = UIColor(red: 0/255, green: 118/255, blue: 205/255, alpha: 1)
    
    static let ButtonBlueDefaultColor = UIColor(red: 31/255, green: 132/255, blue: 212/255, alpha: 1)
    static let ButtonBlueHighlightedColor = UIColor(red: 84/255, green: 150/255, blue: 201/255, alpha: 1)
    
    static let ButtonGrayDefaultColor = UIColor(red: 84/255, green: 106/255, blue: 134/255, alpha: 1)
    static let ButtonGrayHighlightedColor = UIColor(red: 108/255, green: 146/255, blue: 194/255, alpha: 1)
}
