//
//  Facade+Device.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 22.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

extension Facade {
    func getPublicWifi(params: [String: AnyObject], onSuccess: (wifiOrders: [WifiBaseOrder]) -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
        request(Router.GetPublicWifi(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
            Router.globalLog.debug(req)
            Router.globalLog.debug(json)
            onFinish()
            if let error = error {
                Router.globalLog.error(error.debugDescription)
                onError(error: error.localizedDescription)
            } else {
                Router.globalLog.debug(resp)
                var wifiOrders: [WifiBaseOrder] = []
                if let wifiOrdersJson = json["wifi_offer"].array {
                    for subJson in wifiOrdersJson {
                        wifiOrders.append(WifiOffer(json: subJson))
                    }
                } else if let wifiOfferOrdersJson = json["wifi_offer_order"].array {
                    for subJson in wifiOfferOrdersJson {
                        wifiOrders.append(WifiOfferOrder(json: subJson))
                    }
                }
                onSuccess(wifiOrders: wifiOrders)
            }
        })
    }
    
    func connectWifi(params: [String: AnyObject], onSuccess: () -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
        request(Router.ConnectWifi(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
            Router.globalLog.debug(req)
            Router.globalLog.debug(json)
            onFinish()
            if let error = error {
                Router.globalLog.error(error.debugDescription)
                onError(error: error.localizedDescription)
            } else {
                Router.globalLog.debug(resp)
                
                onSuccess()
                
//                if json["msg"].string == "ok" {
//                    onSuccess()
//                } else {
//                    Router.globalLog.error("connectWifi error")
//                    onError(error: LS("error"))
//                }
            }
        })
    }
    
    func disconnectWifi(params: [String: AnyObject], onSuccess: () -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
        request(Router.DisconnectWifi(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
            Router.globalLog.debug(req)
            Router.globalLog.debug(json)
            onFinish()
            if let error = error {
                Router.globalLog.error(error.debugDescription)
                onError(error: error.localizedDescription)
            } else {
                Router.globalLog.debug(resp)
                
                onSuccess()
                
//                if json["msg"].string == "ok" {
//                    onSuccess()
//                } else {
//                    Router.globalLog.error(json["error"].stringValue)
//                    onError(error: json["error"].string == nil ? LS("error") : json["error"].stringValue)
//                }
            }
        })
    }
    
    func subscribeHistoryForMonth(params: [String: AnyObject], onSuccess: (SubscribeMonth) -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
        request(Router.SubscribeHistoryForMonth(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
            Router.globalLog.debug(req)
            Router.globalLog.debug(json)
            onFinish()
            if let error = error {
                onError(error: error.localizedDescription)
            } else {
                Router.globalLog.debug(resp)
                let subscribeMonth = SubscribeMonth(json: json)
                onSuccess(subscribeMonth)
            }
        })
    }
    
    func subscribeHistoryForPeriod(params: [String: AnyObject], onSuccess: (SubscribePeriod) -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
        request(Router.SubscribeHistoryForPeriod(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
            Router.globalLog.debug(req)
            Router.globalLog.debug(json)
            onFinish()
            if let error = error {
                onError(error: error.localizedDescription)
            } else {
                Router.globalLog.debug(resp)
                let subscribePeriod = SubscribePeriod(json: json)
                onSuccess(subscribePeriod)
            }
        })
    }
    
    func getActiveSessions(params: [String: AnyObject], onSuccess: ([[AnyObject]]) -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
        request(Router.GetActiveSessions(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
            Router.globalLog.debug(req)
            Router.globalLog.debug(json)
            onFinish()
            if let error = error {
                onError(error: error.localizedDescription)
            } else {
                Router.globalLog.debug(resp)
                var activeSessions: [[AnyObject]] = []
                
                for subJson in json.arrayValue {
                    let activeSession = ActiveSession(json: subJson)
                    if activeSession.startTime == nil {
                        continue
                    }
                    if activeSessions.count > 0 && (activeSessions.last![0] as! NSDate).isEqualByComponents(activeSession.startTime!) {
                        var groupedPayments = activeSessions[activeSessions.count - 1][1] as! [ActiveSession]
                        groupedPayments.append(activeSession)
                        activeSessions[activeSessions.count - 1][1] = groupedPayments
                    } else {
                        var groupedByDate:[AnyObject] = []
                        groupedByDate.append(activeSession.startTime!)
                        groupedByDate.append([activeSession])
                        activeSessions.append(groupedByDate)
                    }
                }
                onSuccess(activeSessions)
            }
        })
    }
    
}
