//
//  Facade+DeviceSettings.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 29.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

extension Facade {
  
  func setTurboTraffic(params: [String: AnyObject], onSuccess: () -> Void, onError: (error: String) -> Void) {
    request(Router.SetTurboTraffic(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      if let error = error {
        Router.globalLog.error(error.debugDescription)
        onError(error: error.localizedDescription)
      } else {
        Router.globalLog.debug(resp)
        if let success = json["success"].bool {
          if success {
            onSuccess()
          } else {
            onError(error: LS("error"))
          }
        }
      }
    })
  }
  
  func setExtTraffic(params: [String: AnyObject], onSuccess: () -> Void, onError: (error: String) -> Void) {
    request(Router.SetExtTraffic(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      if let error = error {
        Router.globalLog.error(error.debugDescription)
        onError(error: error.localizedDescription)
      } else {
        Router.globalLog.debug(resp)
        if let success = json["success"].bool {
          if success {
            onSuccess()
          } else {
            onError(error: LS("error"))
          }
        }
      }
    })
  }
  
  func getDeviceSettings(device: String, onComplete: (String?, DeviceSettings?) -> Void) {
    let params = [
      "access_token": Facade.accessToken!,
      "client_id": Facade.clientId!,
      "server_id": Facade.serverId!,
      "abonent_id": Facade.accountId!,
      "device": device
      ] as [String: AnyObject]
    request(Router.DeviceSettings(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      let deviceSettings = DeviceSettings(json: json)
      if let error = error {
        Router.globalLog.error(error.debugDescription)
      } else {
        Router.globalLog.debug(resp)
      }
      onComplete(error?.localizedDescription, deviceSettings)
    })
  }
  
  func getTariffPlanChangeHistory(params: [String: AnyObject], onSuccess: ([TariffPlanChangeHistory]) -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
    request(Router.GetTariffPlanChangeHistory(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      onFinish()
      if let error = error {
        Router.globalLog.error(error.debugDescription)
        onError(error: error.localizedDescription)
      } else {
        Router.globalLog.debug(resp)
        var tariffs: [TariffPlanChangeHistory] = []
        if let arr = json.array {
          for subJson in arr {
            tariffs.append(TariffPlanChangeHistory(json: subJson))
          }
        }
        onSuccess(tariffs)
      }
    })
  }
  
  func changeTariff(device: String, tariffId: Int, onComplete: (String?, String?) -> Void) {
    let params = [
      "access_token": Facade.accessToken!,
      "client_id": Facade.clientId!,
      "server_id": Facade.serverId!,
      "abonent_id": Facade.accountId!,
      "device": device,
      "tariff_id": tariffId
      ] as [String: AnyObject]
    request(Router.ChangeTariff(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      if let error = error {
        Router.globalLog.error(error.debugDescription)
      } else {
        Router.globalLog.debug(resp)
      }
      onComplete(error?.localizedDescription, json["msg"].string)
    })
  }
  
  func changeInternetAccessPassword(params: [String: AnyObject], onSuccess: () -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
    request(Router.ChangeInternetAccessPassword(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      onFinish()
      if let error = error {
        Router.globalLog.error(error.debugDescription)
        onError(error: error.localizedDescription)
      } else {
        Router.globalLog.debug(resp)
        if let error = json["error"].dictionary {
          Router.globalLog.error(error)
          onError(error: "\(error.description)")
        } else if let error = json["error"].string {
          Router.globalLog.error(error)
          onError(error: error)
        } else if json["success"].string == "ok" {
          onSuccess()
        } else {
          onError(error: "")
        }
      }
    })
  }
  
  func getPromisedPayment(params: [String: AnyObject], onSuccess: (status: Int) -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
    request(Router.GetPromisedPayment(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      onFinish()
      if let error = error {
        Router.globalLog.error(error.debugDescription)
        onError(error: error.localizedDescription)
      } else {
        Router.globalLog.debug(resp)
        if json["error_code"].intValue == 0 {
          onSuccess(status: json["status"].intValue)
        } else {
          Router.globalLog.error("getPromisedPayment error")
          onError(error: "ошибка")
        }
      }
    })
  }
  
  func savePromisedPayment(params: [String: AnyObject], onSuccess: () -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
    request(Router.SavePromisedPayment(params)).responseSwiftyJSON(completionHandler: { (req, resp, json,
      error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      onFinish()
      if let error = error {
        Router.globalLog.error(error.debugDescription)
        onError(error: error.localizedDescription)
      } else {
        Router.globalLog.debug(resp)
        if json["success"].boolValue {
          onSuccess()
        } else {
          Router.globalLog.error(json["meesage"].stringValue)
          onError(error: json["message"].stringValue)
        }
      }
    })
  }
  
  func addSi(params: [String: AnyObject], onSuccess: () -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
    request(Router.AddSi(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      onFinish()
      if let error = error {
        Router.globalLog.error(error.debugDescription)
        onError(error: error.localizedDescription)
      } else {
        Router.globalLog.debug(resp)
        if json["msg"].string == "ok" {
          onSuccess()
        } else {
          Router.globalLog.error(json["msg"].string != nil ? json["msg"].stringValue : json["error"].string != nil ? json["error"].stringValue : LS("error"))
          onError(error: json["msg"].string != nil ? json["msg"].stringValue : json["error"].string != nil ? json["error"].stringValue : LS("error"))
        }
      }
    })
  }
  
  func removeSi(params: [String: AnyObject], onSuccess: () -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
    request(Router.RemoveSi(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      onFinish()
      if let error = error {
        Router.globalLog.error(error.debugDescription)
        onError(error: error.localizedDescription)
      } else {
        Router.globalLog.debug(resp)
        if json["msg"].string == "ok" {
          onSuccess()
        } else {
          Router.globalLog.error(json["msg"].string != nil ? json["msg"].stringValue : json["error"].string != nil ? json["error"].stringValue : LS("error"))
          onError(error: json["msg"].string != nil ? json["msg"].stringValue : json["error"].string != nil ? json["error"].stringValue : LS("error"))
        }
      }
    })
  }
  
  func changeCreditLimit(params: [String: AnyObject], onSuccess: () -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
    request(Router.ChangeCreditLimit(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      onFinish()
      if let error = error {
        Router.globalLog.error(error.debugDescription)
        onError(error: error.localizedDescription)
      } else {
        Router.globalLog.debug(resp)
        if let error = json["error"].dictionary {
          Router.globalLog.error(error)
          onError(error: "\(error.description)")
        } else if let error = json["error"].string {
          Router.globalLog.error(error)
          onError(error: error)
        } else if json["msg"].string == "ok" {
          onSuccess()
        } else {
          Router.globalLog.error("changeCreditLimit error")
          onError(error: "")
        }
      }
    })
  }
  
  func getStaticIp(params: [String: AnyObject], onSuccess: (String) -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
    request(Router.GetStaticIpAddress(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      onFinish()
      if let error = error {
        Router.globalLog.error(error.debugDescription)
        onError(error: error.localizedDescription)
      } else {
        Router.globalLog.debug(resp)
        if let error = json["error"].dictionary {
          Router.globalLog.error(error)
          onError(error: "\(error.description)")
        } else if let error = json["error"].string {
          Router.globalLog.error(error)
          onError(error: error)
        } else if json["success"].bool == true {
          onSuccess(json["status"].stringValue)
        } else {
          Router.globalLog.error("getStaticIp error")
          onError(error: "")
        }
      }
    })
  }
  
  func changeStaticIp(params: [String: AnyObject], onSuccess: (String) -> Void, onError: (error: String) -> Void, onFinish: () -> Void) -> Request {
    return request(Router.ChangeStaticIp(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      onFinish()
      if let error = error {
        if error.code != -999 {
          Router.globalLog.error(error.debugDescription)
          onError(error: error.localizedDescription)
        }
      } else {
        Router.globalLog.debug(resp)
        if let error = json["error"].dictionary {
          Router.globalLog.error(error)
          onError(error: "\(error.description)")
        } else if let error = json["error"].string {
          Router.globalLog.error(error)
          onError(error: error)
        } else if json["success"].bool == true {
          onSuccess(json["message"].stringValue)
        } else if json["success"].bool == false {
          Router.globalLog.error("getStaticIp error")
          onError(error: json["message"].stringValue)
        }
      }
    })
  }
  
  func checkParentalControl(params: [String: AnyObject], onSuccess: (ParentalControl) -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
    request(Router.CheckParentalControl(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      onFinish()
      if let error = error {
        Router.globalLog.error(error.debugDescription)
        onError(error: error.localizedDescription)
      } else {
        Router.globalLog.debug(resp)
        if let error = json["error"].dictionary {
          Router.globalLog.error(error)
          onError(error: "\(error.description)")
        } else if let error = json["error"].string {
          Router.globalLog.error(error)
          onError(error: error)
        } else {
          let parentalControl = ParentalControl(json: json)
          onSuccess(parentalControl)
        }
      }
    })
  }
  
}
