//
//  Facade+Menu.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 26.08.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

extension Error {
    
    func alertDescription() {
        
    }
    
}

extension Facade {
    
    func getMenuItems(id: Int, onSuccess: ([[String: AnyObject]], [FeedItem]) -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
        request(Router.GetMenu(id)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
            Router.globalLog.debug(req)
            Router.globalLog.debug(json)
            onFinish()
            if let error = error {
                Router.globalLog.error(error.debugDescription)
                onError(error: error.localizedDescription)
            } else {
                Router.globalLog.debug(resp)
                if let error = json["error"].dictionary {
                    Router.globalLog.error(error)
                    onError(error: "\(error.description)")
                } else if let error = json["error"].string {
                    Router.globalLog.error(error)
                    onError(error: error)
                } else {
                    var feedList : [FeedItem] = []
                    if let feedItems = json.array, let menuItems = json.arrayObject as? [[String: AnyObject]] {
                        for firstLevel in feedItems {
                            if let secondLevel = firstLevel["data"].array {
                                for serviceItem in secondLevel {
                                    if let full = serviceItem["full"].dictionary {
                                        let item = FeedItem()
                                        item.title = serviceItem["name"].string
                                        item.id = serviceItem["service_id"].int
                                        item.desc = full["seo_description"]?.stringValue
                                        item.image = full["seo_image"]?.stringValue
                                        if item.id == 389 || item.id == 391 || item.id == 393 || item.id == 401 {
                                            var found : Bool = false
                                            for model in feedList {
                                                if model.id == item.id {
                                                    found = true
                                                }
                                            }
                                            if !found {
                                                feedList.append(item)
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        onSuccess(menuItems, feedList)
                    } else {
                        let mItems : [[String: AnyObject]] = []
                        onSuccess(mItems, feedList)
                    }
                }
            }
        })
    }
    
}
