//
//  Facade+Siebel.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 17.11.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

extension Facade {
  func siebelClaimCreate(params: [String: AnyObject], onSuccess: ([SiebelClaim]) -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
    request(Router.SiebelClaimCreate(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      onFinish()
      if let error = error {
        onError(error: error.localizedDescription)
      } else {
        Router.globalLog.debug(resp)
        var siebelClaims: [SiebelClaim] = []
        if let jsonArr = json.array {
          for subJson in jsonArr {
            siebelClaims.append(SiebelClaim(json: subJson))
          }
        }
        onSuccess(siebelClaims)
      }
    })
  }
  
  func getClaimSourceSubList(params: [String: AnyObject], onSuccess: ([ClaimSourceSub]) -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
    request(Router.SiebelGetClaimSourceSubList(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      onFinish()
      if let error = error {
        onError(error: error.localizedDescription)
      } else {
        Router.globalLog.debug(resp)
        var claimSourceSubs: [ClaimSourceSub] = []
        if let jsonArr = json.array {
          for subJson in jsonArr {
            claimSourceSubs.append(ClaimSourceSub(json: subJson))
          }
        }
        onSuccess(claimSourceSubs)
      }
    })
  }
  
  func getClaimSourceList(params: [String: AnyObject], onSuccess: ([ClaimSource]) -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
    request(Router.SiebelGetClaimSourceList(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      onFinish()
      if let error = error {
        onError(error: error.localizedDescription)
      } else {
        Router.globalLog.debug(resp)
        var claimSources: [ClaimSource] = []
        if let jsonArr = json.array {
          for subJson in jsonArr {
            claimSources.append(ClaimSource(json: subJson))
          }
        }
        onSuccess(claimSources)
      }
    })
  }
  
  func getClaimList(params: [String: AnyObject], onSuccess: ([Claim]) -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
    request(Router.SiebelGetClaimList(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      onFinish()
      if let error = error {
        onError(error: error.localizedDescription)
      } else {
        Router.globalLog.debug(resp)
        var claims: [Claim] = []
        if let jsonArr = json.array {
          for subJson in jsonArr {
            claims.append(Claim(json: subJson))
          }
        }
        onSuccess(claims)
      }
    })
  }
  
  func claimDelete(params: [String: AnyObject], onSuccess: () -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
    request(Router.SiebelClaimDelete(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      onFinish()
      if let error = error {
        onError(error: error.localizedDescription)
      } else {
        Router.globalLog.debug(resp)
        if json["success"].boolValue {
          onSuccess()
        } else {
            if let errorCode = json["error_code"].int, let errorMsg = json["error"].string where errorCode != 0 {
                Router.globalLog.error("errorCode: \(errorCode), errorMsg: \(errorMsg)")
                onError(error: errorMsg)
            } else {
                onError(error: "")
            }

        }
      }
    })
  }
  
    func damageDelete(params: [String: AnyObject], onSuccess: () -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
        request(Router.SiebelDamageDelete(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
            Router.globalLog.debug(req)
            Router.globalLog.debug(json)
            onFinish()
            if let error = error {
                onError(error: error.localizedDescription)
            } else {
                Router.globalLog.debug(resp)
                if json["success"].boolValue {
                    onSuccess()
                } else {
                    
                    if let errorCode = json["error_code"].int, let errorMsg = json["error"].string where errorCode != 0 {
                        Router.globalLog.error("errorCode: \(errorCode), errorMsg: \(errorMsg)")
                        onError(error: errorMsg)
                    } else {
                        onError(error: "")
                    }
                }
            }
        })
    }
  
  func damageCreate(params: [String: AnyObject], onSuccess: ([Damage]) -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
    request(Router.SiebelDamageCreate(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      onFinish()
      if let error = error {
        onError(error: error.localizedDescription)
      } else {
        Router.globalLog.debug(resp)
        if let error = json["errors"].string {
          onError(error: error)
        } else {
          var damages: [Damage] = []
          if let jsonArr = json.array {
            for subJson in jsonArr {
              damages.append(Damage(json: subJson))
            }
          }
          onSuccess(damages)
        }
      }
    })
  }
  
  func getDamageSourceList(params: [String: AnyObject], onSuccess: ([DamageSource]) -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
    request(Router.SiebelGetDamageSourceList(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      onFinish()
      if let error = error {
        onError(error: error.localizedDescription)
      } else {
        Router.globalLog.debug(resp)
        var damageSources: [DamageSource] = []
        if let jsonArr = json.array {
          for subJson in jsonArr {
            damageSources.append(DamageSource(json: subJson))
          }
        }
        onSuccess(damageSources)
      }
    })
  }
  
  func getDamageList(params: [String: AnyObject], onSuccess: ([FullDamage]) -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
    request(Router.SiebelGetDamageList(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      onFinish()
      if let error = error {
        onError(error: error.localizedDescription)
      } else {
        Router.globalLog.debug(resp)
        var damages: [FullDamage] = []
        if let jsonArr = json.array {
          for subJson in jsonArr {
            damages.append(FullDamage(json: subJson))
          }
        }
        onSuccess(damages)
      }
    })
  }
  
  func getSiebelAccount(params: [String: AnyObject], onSuccess: (SiebelAccount) -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
    request(Router.SiebelAccountGet(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      onFinish()
      if let error = error {
        onError(error: error.localizedDescription)
      } else {
        Router.globalLog.debug(resp)
        let siebelAccount = SiebelAccount(json: json)
        onSuccess(siebelAccount)
      }
    })
  }
  
}
