//
//  Facade+WiFi.swift
//  kt
//
//  Created by Alexandr Zalutskiy on 28.01.15.
//  Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

let FacadeWiFiPointsSuccess = "FacadeWiFiPointsSuccess"

extension Facade {
  
  func getWiFiPointsForCityId(id : Int) {
    request(Router.WiFiPointsForCity(id)).responseSwiftyJSON {
      (req, resp, json, error) in
      
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      if let error = error {
        Router.globalLog.error(error.debugDescription)
      } else {
        Router.globalLog.debug(resp)
      }
      
      var points = [WiFi]()
      
      for (_, subJson) in json {
        points.append(WiFi(json: subJson))
      }
      
      self.notificationCenter.postNotificationName(
        FacadeWiFiPointsSuccess,
        object: self,
        userInfo: ["points" : points]
      )
    }
  }
  
  func getWiFiPointsForCity(city : City) {
    getWiFiPointsForCityId(city.id)
  }
}
