//
//  CellsManager.swift
//  kt
//
//  Created by Admin on 05.12.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

extension UITableViewCell {
    func hideSeparatorLine() {
        self.separatorInset = UIEdgeInsetsMake(0, self.bounds.size.width, 0, 0)        
    }
    
    func showSeparatorLine() {
        self.separatorInset = UIEdgeInsetsMake(1, self.bounds.size.width, 1, 1)
    }
}

enum CellType {
    case TitleValueCell
    case RBCell
    case ComboBoxCell
    case TextBoxCell
    case TextBoxCellWithInfo
    case ListBoxItemCell
    case FastPayCell
    
    
    var reuseIdentifier : String {
        var result = ""
        switch self {
        case .TitleValueCell:
            result = "titleValueCellIdentifier"
            break
        case .RBCell:
            result = "rbCellIdentifier"
            break
        case .ComboBoxCell:
            result = "comboBoxCellIdentifier"
            break
        case .TextBoxCellWithInfo:
            result = "textBoxWithInfoCellIdentifier"
            break
        case .TextBoxCell:
            result = "textBoxCellIdentifier"
            break
        case .ListBoxItemCell:
            result = "listBoxItemCellIdentifier"
            break
        case .FastPayCell:
            result = "fastPayCellIdentifier"
        }
        return result
    }
}

class CellsManager {
    
    static func CreateCell(tableView: UITableView, cellType : CellType) -> UIBaseTableViewCell {
        let cell = tableView.dequeueReusableCellWithIdentifier(cellType.reuseIdentifier) as! UIBaseTableViewCell
        return cell
    }
    
}
