//
//  UserManager.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 14.06.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class UserManager {
 
    var rLogin : String = ""
    var rPassword : String = ""
    var rLoginType : Int = 0
    
    var login: String? {
    get {
      return NSUserDefaults.standardUserDefaults().stringForKey("login")
    }
    set(newValue) {
      NSUserDefaults.standardUserDefaults().setValue(newValue, forKey: "login")
    }
  }
  var password: String? {
    get {
      return NSUserDefaults.standardUserDefaults().stringForKey("password")
    }
    set(newValue) {
      NSUserDefaults.standardUserDefaults().setValue(newValue, forKey: "password")
    }
  }
  
    var cities: [[String]]? {
        set {
            NSUserDefaults.standardUserDefaults().setObject(newValue, forKey: "offers_cities")
        }
        get {
            return NSUserDefaults.standardUserDefaults().objectForKey("offers_cities") as? [[String]]
        }
    }
    
  class func sharedInstance() -> UserManager {
    struct Shared {
      static let sharedInstance : UserManager = UserManager()
    }
    return Shared.sharedInstance
  }
  
  private init() {
    
  }
}
