//
//  BotNode.swift
//  kt
//
//  Created by neox on 12.07.17.
//  Copyright © 2017 SimpleCode. All rights reserved.
//

import UIKit

class BotNode: NSObject, NSCoding {

    var id : String?
    var parentId : String?
    var linkTo : String?
    var formId : String?
    var text : String?
    var expanded : Int?
    var isLink : Int?
    
    override init() {
        super.init()
    }
    
    required init?(coder aDecoder: NSCoder) {
        id = aDecoder.decodeObjectForKey("id") as! String?
        parentId = aDecoder.decodeObjectForKey("parentId") as! String?
        linkTo = aDecoder.decodeObjectForKey("linkTo") as! String?
        formId = aDecoder.decodeObjectForKey("formId") as! String?
        text = aDecoder.decodeObjectForKey("text") as! String?
        expanded = aDecoder.decodeObjectForKey("expanded") as! Int?
        isLink = aDecoder.decodeObjectForKey("isLink") as! Int?
    }
    
    func encodeWithCoder(aCoder: NSCoder) {
        aCoder.encodeObject(id, forKey: "id")
        aCoder.encodeObject(parentId, forKey: "parentId")
        aCoder.encodeObject(linkTo, forKey: "linkTo")
        aCoder.encodeObject(formId, forKey: "formId")
        aCoder.encodeObject(text, forKey: "text")
        aCoder.encodeObject(expanded, forKey: "expanded")
        aCoder.encodeObject(isLink, forKey: "isLink")
    }
    
}
