//
// Created by Alexander Zalutskiy on 17.08.15.
// Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class AbonentInfo {
  let login: String?
  let balance: Double?
  let name: String?
  let mobilePhone: Int64?
  var email: String?
  let address: String?
  let phones: [String]?
  
  convenience init(dict: [String: AnyObject]) {
    self.init(json: JSON(dict))
  }
  
  
  //  "account_balance" = "-11135.65";
  //  outabonentaddress = "\U041f\U0430\U0432\U043b\U043e\U0434\U0430\U0440, 140000, \U0443\U043b.\U0413\U0415\U041d\U0415\U0420\U0410\U041b\U0410 \U0414\U042e\U0421\U0415\U041d\U041e\U0412\U0410, \U0434.10, \U043a\U0432.79";
  //  outabonentname = "\U041b\U0415\U041d\U0421\U041a\U0410\U042f \U0412\U0410\U041b\U0415\U041d\U0422\U0418\U041d\U0410 \U041f\U0415\U0422\U0420\U041e\U0412\U041d\U0410";
  //  outemail = "SLedgeHamer@yandex.ru";
  //  outerrcodeout = 0;
  //  outmobilepnone = "";
  //  outmsg = Ok;
  //  phones =     (
  //  "+77182 533443"
  //  )
  
  init(json: JSON) {
    //    if let balance = json["account_balance"].double,
    //      let name = json["outabonentname"].string,
    //      let mobilePhone = json["outmobilepnone"].int64,
    //      let email = json["outemail"].string,
    //      let address = json["outabonentaddress"].string,
    //      let phones = json["phones"].arrayObject {
    self.login = json["login"].stringValue
    self.balance = json["account_balance"].doubleValue
    self.name = json["outabonentname"].string
    self.mobilePhone = json["outmobilepnone"].int64
    self.email = json["outemail"].string
    self.address = json["outabonentaddress"].string
    self.phones = json["phones"].arrayObject as? [String]
    //    } else {
    //      self.balance = 0
    //      self.name = ""
    //      self.mobilePhone = 0
    //      self.email = ""
    //      self.address = ""
    //      self.phones = [""]
    //    }
  }
}
