//
//  TariffPlanChangeHistory.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 06.06.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class TariffPlanChangeHistory {
//  "packet_type_name": "Megaline Hit",
//  "system_date": "12-JAN-16",
//  "operation": "UPD"
  var packetTypeName: String?
  var systemDate: NSDate?
  var operation: String?
  
  init(json: JSON) {
    self.packetTypeName = json["packet_type_name"].string
    if let systemDate = json["system_date"].string {
      let dateFormatter = NSDateFormatter()
      dateFormatter.locale = NSLocale(localeIdentifier: "en_US_POSIX")
      dateFormatter.dateFormat = "dd-MM-yy"
      self.systemDate = dateFormatter.dateFromString(systemDate)
    }
    self.operation = json["operation"].string
  }
  
}
