//
//  CallbackLocationProtocol.swift
//  kt
//
//  Created by Alexandr Zalutskiy on 02.02.15.
//  Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

protocol CallbackLocationProtocol {
	var serviceId: Int {get set}
	
	func routerForRow(row: Int) -> Router
	var currentCountOfCell: Int {get}
	func getInfoForRow(row: Int) -> (
		defaultSettings: (title: String, placeholder: String),
		info: CallbackPlaceProtocol?
	)
	func setInfo(info: CallbackPlaceProtocol, forRow row: Int)
	var enableCallback : Bool {get}
}

@objc protocol CallbackPlaceProtocol {
	var text : String {get set}
	var id : Int {get set}
}