//
//  Tariff.swift
//  kt
//
//  Created by Alexandr Zalutskiy on 30.01.15.
//  Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class Tariff {
	var id: Int
	var name: String
	var price: Int
	
	var traffic: String?
	var speed: Int?
	var speedMin: Int? //0 - безлимит
	var channels: Int?
	
	init(json: JSON) {
		id = json["id"].intValue
		name = json["name"].stringValue
		price = json["price"].intValue
		
		traffic = json["traffic"].string
		speed = json["speed"].int
		speedMin = json["speed_min"].int
		channels = json["channels"].int
	}
	
	var cellCount: Int {
		var _cellCount = 1
		if traffic != nil {
			_cellCount += 1
		}
		if speed != nil {
			_cellCount += 1
		}
		if speedMin != nil {
			_cellCount += 1
		}
		if channels != nil {
			_cellCount += 1
		}
		return _cellCount
	}
	
	var titles : [String] {
		var _titles = [LocalizedString("tariff.price_per_month", description: "Цена (тг)").uppercaseString]
		if traffic != nil {
			_titles.append(LocalizedString("tariff.traffic", description: "Трафик").uppercaseString)
		}
		if speed != nil {
			_titles.append(LocalizedString("tariff.internet_speed", description: "Скорость интернета до (Мбит/с)").uppercaseString)
		}
		if speedMin != nil {
			_titles.append(LocalizedString("tariff.internet_speed_min", description: "Минимальная скорость").uppercaseString)
		}
		if channels != nil {
			_titles.append(LocalizedString("tariff.channel_count", description: "Количество каналов").uppercaseString)
		}
		return _titles
	}
	
	var values : [String] {
		var _values = ["\(price) тг"]
		if traffic != nil {
			_values.append(traffic!)
		}
		if speed != nil {
			_values.append("\(speed!)")
		}
		if speedMin != nil {
			if speedMin == 0 {
                //TODO: Localized
				_values.append("Безлимит")
			} else {
				_values.append("\(speedMin!)")
			}
		}
		if channels != nil {
			_values.append("\(channels!)")
		}
		return _values
	}
}