//
//  GetCardAndBankTypes.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 02.06.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

//GetCardAndBankTypes

class GetCardAndBankTypes {
  var accessToken: String?
  var clientId: String?
  var serverId: Int?
  var abonentId: Int?
  
  init(accessToken: String? = nil, clientId: String? = nil, serverId: Int? = nil, abonentId: Int? = nil) {
    self.accessToken = accessToken
    self.clientId = clientId
    self.serverId = serverId
    self.abonentId = abonentId
  }
  
  func validateFields() -> Bool {
    var isValid = true
    if accessToken.isNilOrEmpty || clientId.isNilOrEmpty || serverId == nil || abonentId == nil {
      isValid = false
    }
    return isValid
  }
  
  var params: [String: AnyObject] {
    return ["access_token": self.accessToken!,
            "client_id": self.clientId!,
            "server_id": self.serverId!,
            "abonent_id": self.abonentId!]
  }
}
