//
//  ScrolledViewController.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 28.01.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class ScrolledViewController : KeyboardedViewController {
    
    @IBOutlet weak var scrollView: UIScrollView!
    @IBOutlet var contentView: UIView!
    //  @IBOutlet var contentViewHeight: NSLayoutConstraint!
    weak var activeField: UITextField?
    @IBOutlet var helpButtonBottomSpace: NSLayoutConstraint!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.automaticallyAdjustsScrollViewInsets = false
        registerForKeyboardAction()
        view.addGestureRecognizer(tapGestureRecognizer)
    }
    
    override func viewWillAppear(animated: Bool) {
        super.viewWillAppear(animated)
    }
    
    func resizeScrollViewToFitSubviews() {
        if contentView == nil || scrollView == nil
        {
            return
        }
        contentView.resizeToFitSubviews()
        //    let resultHeight = view.frame.height > contentView.frame.height ? view.frame.height : contentView.frame.height
        //    contentViewHeight.constant = contentView.frame.height
        //    contentView.layoutIfNeeded()
        scrollView.contentSize = CGSize(width: scrollView.frame.size.width, height: contentView.frame.height)
        //    scrollView.sizeToFit()
        //    scrollView.layoutIfNeeded()
    }
    
    private func registerForKeyboardAction() {
        let notificationCenter = NSNotificationCenter.defaultCenter()
        notificationCenter.addObserver(self, selector: #selector(ScrolledViewController.keyboardDidShow(_:)),
                                       name:UIKeyboardWillShowNotification, object: nil)
        notificationCenter.addObserver(self, selector: #selector(ScrolledViewController.keyboardWillBeHidden(_:)),
                                       name: UIKeyboardWillHideNotification, object: nil)
    }
    
    // MARK: Keyboard action
    func keyboardDidShow(notification: NSNotification) {
        if contentView == nil || scrollView == nil
        {
            return
        }
        CustomKeyboardManager.sharedInstance().notification = notification
        tapGestureRecognizer.enabled = true
        let info = notification.userInfo!
        var kbRect = info[UIKeyboardFrameBeginUserInfoKey]!.CGRectValue
        kbRect = view.convertRect(kbRect, fromView: nil)
        
        if helpButtonBottomSpace == nil {
            //      bottom = keyboard height + register button height
            let contentInsets = UIEdgeInsets(top: 0.0, left: 0.0,
                                             bottom:	kbRect.height, right: 0.0)
            scrollView.contentInset = contentInsets
            scrollView.scrollIndicatorInsets = contentInsets
        } else {
            //     keyboard height + register button height
            helpButtonBottomSpace.constant = kbRect.height
        }    //    //
        let aRect = view.frame
        if let textField = activeField	where !CGRectContainsPoint(aRect, textField.frame.origin) {
            scrollView.scrollRectToVisible(textField.frame, animated: true)
        }
        CustomKeyboardManager.sharedInstance().isVisible = true
    }
    
    func keyboardWillBeHidden(notification: NSNotification) {
        if contentView == nil || scrollView == nil
        {
            return
        }
        CustomKeyboardManager.sharedInstance().notification = nil
        CustomKeyboardManager.sharedInstance().isVisible = false
        tapGestureRecognizer.enabled = false
        helpButtonBottomSpace?.constant = 0
        let contentInsets = UIEdgeInsetsZero
        scrollView.contentInset = contentInsets
        scrollView.scrollIndicatorInsets = contentInsets
        resizeScrollViewToFitSubviews()
        scrollView.contentOffset = CGPointZero
    }
    
    //  @IBAction func hideKeyboardOnTap(sender: UITapGestureRecognizer) {
    //    view.endEditing(true)
    //  }
    
}

// UITextFieldDelegate
extension ScrolledViewController {
    
    func textFieldDidBeginEditing(textField: UITextField) {
        activeField = textField
        textField.setBottomBorder(Color.BlueButtonColor)
    }
    
    func textFieldDidEndEditing(textField: UITextField) {
        activeField = nil
        textField.setBottomBorder(Color.GrayTableCellSeparator)
    }
}
