//
//  BotRightMessageCell.swift
//  kt
//
//  Created by neox on 13.07.17.
//  Copyright © 2017 SimpleCode. All rights reserved.
//

import UIKit

class BotRightMessageCell: UITableViewCell {

    @IBOutlet weak var container: UIView!
    @IBOutlet weak var stackView: UIStackView!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        container.layer.cornerRadius = 4
        container.backgroundColor = Color.KTDefaultBlueColor
    }
    
    func bind(nodes : [BotNode]?) {
        for view in stackView.subviews {
            view.removeFromSuperview()
        }
        for node in nodes! {
            if let text = node.text {
                let label = UITextView(frame: CGRectMake(0, 0, 0, 0))
                label.textAlignment = NSTextAlignment.Left
                label.editable = false
                label.scrollEnabled = false
                label.text = text
                label.backgroundColor = UIColor.clearColor()
                label.font = UIFont.systemFontOfSize(14)
                label.textColor = UIColor.whiteColor()
                label.sizeToFit()
                self.stackView.addArrangedSubview(label)
            }
        }
    }
}
