//
//  FeedViewController.swift
//  kt
//
//  Created by neox on 27.06.17.
//  Copyright © 2017 SimpleCode. All rights reserved.
//

import UIKit

class FeedViewController: ViewControllerWithMenu {
    
    @IBOutlet weak var tableView: UITableView!
    
    var feedData : [FeedItem] = []
    
    override func viewDidLoad() {
        
        super.viewDidLoad()
        
        self.navigationItem.title = "Главная"
        
        refreshBalance()
        
        tableView.estimatedRowHeight = 44.0;
        tableView.rowHeight = UITableViewAutomaticDimension;
        tableView.separatorStyle = .None
        
    }
    
    func refreshBalance() {
        SpinneredAlert.show(self)
        AbonentInfoManager.sharedInstance.updateUserInfo()
        
//        Facade.sharedInstance().getPaymentList({ (payments) in
//            print(payments)
//            
//            }, onError: { (error) in
//                AlertViewUtil.showIncorrectAlert(error)
//            }, onFinish: { () in
//        })
        
    }
    
    override func viewWillAppear(animated: Bool) {
        super.viewWillAppear(animated)
        configureBlueNavbar()
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
    
    func numberOfSectionsInTableView(tableView: UITableView) -> Int {
        return 1
    }
    
    func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return 3
    }
    
    func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
        if indexPath.row == 0 {
            let cell = tableView.dequeueReusableCellWithIdentifier("FeedPaymentCell", forIndexPath: indexPath) as! FeedPaymentCell
            cell.navController = self.navigationController!
            cell.selectionStyle = UITableViewCellSelectionStyle.None
            return cell
        } else if indexPath.row == 1 {
            let cell = tableView.dequeueReusableCellWithIdentifier("FeedPackagesCell", forIndexPath: indexPath) as! FeedPackagesCell
            cell.navController = self.navigationController
            cell.selectionStyle = UITableViewCellSelectionStyle.None
            return cell
        } else {
            let cell = tableView.dequeueReusableCellWithIdentifier("FeedBotCell", forIndexPath: indexPath) as! FeedBotCell
            cell.navController = self.navigationController
            cell.selectionStyle = UITableViewCellSelectionStyle.None
            return cell
        }
    }
    
    func tableView(tableView: UITableView, didSelectRowAtIndexPath indexPath: NSIndexPath) {

//        let storyBoard : UIStoryboard = UIStoryboard(name: "Main", bundle:nil)
//        let vc = storyBoard.instantiateViewControllerWithIdentifier("BotViewController")
//        self.navigationController?.pushViewController(vc, animated: true)
        
//        SharedDataManager.sharedInstance().selectedServiceID = feedData[indexPath.row].id
//        
//        let serviceItem = ServiceItem()
//        serviceItem.id = feedData[indexPath.row].id
//        serviceItem.name = feedData[indexPath.row].title
//        serviceItem.type = "landing"
//        
//        let vc = storyboard!.instantiateViewControllerWithIdentifier("ServiceItemScrollViewController") as! ServiceItemScrollViewController
//        vc.serviceItemForLoading = serviceItem
//        self.navigationController?.pushViewController(vc, animated: true)
        
    }
    
    @IBAction func payButton(sender: AnyObject) {
        let nvc = storyboard!.instantiateViewControllerWithIdentifier("OnlinePaymentViewController") as! OnlinePaymentViewController
        self.navigationController?.pushViewController(nvc, animated: true)
    }
}

extension UIImageView {
    public func imageFromServerURL(urlString: String) {
        NSURLSession.sharedSession().dataTaskWithURL(NSURL(string: urlString)!, completionHandler: { (data, response, error) -> Void in
            if error != nil {
                print(error)
                return
            }
            dispatch_async(dispatch_get_main_queue(), { () -> Void in
                let image = UIImage(data: data!)
                self.image = image
            })
        }).resume()
    }}
