//
//  SecondStepOfRegistrationVC.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 28.01.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class SecondStepOfRegistrationVC : StepViewController {
    
    @IBOutlet weak var screenTitle: UILabel!
    
    @IBOutlet weak var loginTitle: UILabel!
    @IBOutlet weak var passwordTitle: UILabel!
    
    @IBOutlet weak var loginField: UITextField!
    @IBOutlet weak var passwordField: UITextField!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        stepNumber = 2
    }
    
    override func viewDidAppear(animated: Bool) {
        super.viewDidAppear(animated)
        self.loginField.placeholder = LS("registration_placeholder_login")
        self.passwordField.placeholder = LS("registration_placeholder_password")
    }
    
    override func viewWillAppear(animated: Bool) {
        super.viewWillAppear(animated)
        localizeSubviews()
        loginField.setBottomBorder(Color.GrayTableCellSeparator)
        passwordField.setBottomBorder(Color.GrayTableCellSeparator)
    }
    
    @IBAction func nextTap(sender: AnyObject) {
        
        let login = loginField.text!
        let password = passwordField.text!

        if login.characters.count == 0 || password.characters.count == 0 {
            AlertViewUtil.showMessageAlert(LS("registration.enter_fields"), vc: self)
            return
        }
        
        var errorMessage : String = ""
        
        if !Validator.isValidLogin(loginField.text!) {
            errorMessage += LS("registration.incorrect_login") + "\n"
        }
        
        if !Validator.isValidPassword(passwordField.text!) {
            errorMessage += LS("registration.incorrect_password") + "\n"
        }
        
        if errorMessage != "" {
            AlertViewUtil.showMessageAlert(errorMessage, vc: self)
            return
        }
        
        AbonentForRegister.sharedInstance().inLogin = loginField.text!
        AbonentForRegister.sharedInstance().inPassword = passwordField.text!
        
        performSegueWithIdentifier("goToThirdStep", sender: nil)
    }

    @IBAction func backTap(sender: AnyObject) {
        navigationController?.popViewControllerAnimated(true)
    }
    
    func localizeSubviews() {
//        localizeParentSubviews()
//        loginField.localizeWithParent(self, localizedId: "login")
//        passwordField.localizeWithParent(self, localizedId: "password")
//        retryPasswordField.localizeWithParent(self, localizedId: "retry_password")
//        nextButton.setTitle(LocalizedString("registration.button.next"), forState: UIControlState.Normal)
    }
}
