//
//  BillPositionsModalViewController.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 25.10.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class BillPositionsModalViewController: UIViewController, UITableViewDataSource {
    
    @IBOutlet weak var tableView: UITableView!
    var billPositions: [Bill.BillPos] = []
    
    func configureTableView() {
        tableView.rowHeight = UITableViewAutomaticDimension
        tableView.estimatedRowHeight = 50
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.title = LS("cash_and_payments.details.title")
        
        print("size = \(billPositions.count)")
        
        addBackButtonForModal(.whiteColor())
        configureBlueNavbar()
        configureTableView()
    }
}

// UITableViewDataSource
extension BillPositionsModalViewController {
    
    func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return billPositions.count
    }
    
    func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCellWithIdentifier("cell", forIndexPath: indexPath) as! BillsPositionCell
        cell.leftLabel.setTextAndSizeToFit(billPositions[indexPath.row].billPosName)
        cell.rightLabel.setTextAndSizeToFit(billPositions[indexPath.row].debit == nil ? "" : "\(Int(billPositions[indexPath.row].debit!)) тг.")
        cell.rightLabel.textAlignment = NSTextAlignment.Right
        //cell.selectionStyle = .None
        return cell
    }
}
