//
//  OffersViewController.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 09.02.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class OffersViewController : UIViewController {
    
    var pageVC: MAPageViewController?
    var vcList = [UIViewController]()
    @IBOutlet weak var textView: UITextView!
    @IBOutlet weak var offersImageView: UIImageView!
    let reuseCellIdentifier = "cell"
    var currentImageIndex:Int?
    var currentDotId: Int?
    var specialOffers:[SpecialOffer] = []
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setPages()
        addBackButtonForDefault(.whiteColor())
        configureBlueNavbar()
    }
    
    private func setPages() {
        guard !specialOffers.isEmpty else { AlertViewUtil.showAlert(LS("offer_form.label.no_offers")); return }
        for specialOffer in specialOffers {
            let vc = UIViewController()
            let offerView = OfferView.instanceFromNib()
            vc.view.addSubview(offerView)
            offerView.translatesAutoresizingMaskIntoConstraints = false
            vc.view.addConstraints(NSLayoutConstraint.constraintsWithVisualFormat("H:|[offer_view]|", options: [], metrics: nil, views: ["offer_view": offerView]))
            vc.view.addConstraints(NSLayoutConstraint.constraintsWithVisualFormat("V:|[offer_view]|", options: [], metrics: nil, views: ["offer_view": offerView]))
            
            ImageLoader.sharedLoader.imageForUrl(specialOffer.background!) { (image, url) in
                offerView.pictureView.image = image?.imageWithRenderingMode(.AlwaysOriginal)
            }
            
            ImageLoader.sharedLoader.imageForUrl(specialOffer.logo!) { (image, url) in
                offerView.topIconView.image = image?.imageWithRenderingMode(.AlwaysOriginal)
            }
            offerView.textView.link(specialOffer.text!, link: "https://telecom.kz/\(specialOffer.link!)", fontSize: 17, textAlignment: NSTextAlignment.Center)
            
            offerView.textView.sizeToFit()
            offerView.textViewHeight.constant = offerView.textView.frame.height
            vcList.append(vc)
        }
        pageVC = MAPageViewController(viewControllers: vcList)
        pageVC!.view.frame = self.view.frame
        pageVC!.view.translatesAutoresizingMaskIntoConstraints = false
        pageVC!.pageControl.currentPageIndicatorTintColor = UIColor.grayColor()
        pageVC!.pageControl.pageIndicatorTintColor = UIColor.lightGrayColor()
        self.addChildViewController(pageVC!)
        self.view.addSubview(pageVC!.view)
        let views = ["pageVC": pageVC!.view]
        self.view.addConstraints(NSLayoutConstraint.constraintsWithVisualFormat("H:|[pageVC]|", options: [], metrics: nil, views: views))
        self.view.addConstraints(NSLayoutConstraint.constraintsWithVisualFormat("V:|[pageVC]|", options: [], metrics: nil, views: views))
    }
    
    override func viewWillAppear(animated: Bool) {
        super.viewWillAppear(animated)
        localize()
    }
}

extension OffersViewController {
    override var localizedId: String {
        return "offers"
    }
}
