//
//  FeedbackViewController.m
//  kt
//
//  Created by Alexandr Zalutskiy on 31.01.15.
//  Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

#import "FeedbackViewController.h"

#import "KTAudioCallViewController.h"
#import "Reachability.h"
#import "PZSideMenuViewController.h"
//#import "telecom-Swift.h"
//#import "telecom-Swift.h"
//#import "ViewControllerWithCustomTitle.swift"

#define kNetworkAlertMsgThreedGNotEnabled			@"Only 3G network is available. Please enable 3G and try again."
#define kNetworkAlertMsgNotReachable				@"No network connection"
#define kAlertMsgButtonOkText						@"OK"

//@synthesize supportButton;
//@synthesize repairButton;
//@synthesize subtitleLabel;
//@synthesize button1DescriptionLabel;
//@synthesize button2DescriptionLabel;
//@synthesize menuButton;
//@synthesize multitaskingSupported;

#define kTAG @"Kazaktelecom///: "
#define TAG kTAG

@interface FeedbackViewController()
@property (weak, nonatomic) IBOutlet UIButton *supportButton;
@property (weak, nonatomic) IBOutlet UIButton *repairButton;
@property (weak, nonatomic) IBOutlet UILabel *subtitleLabel;
@property (weak, nonatomic) IBOutlet UILabel *button1DescriptionLabel;
@property (weak, nonatomic) IBOutlet UILabel *button2DescriptionLabel;
@property (nonatomic, strong) UIButton *menuButton;
@property (nonatomic) BOOL multitaskingSupported;
@property (nonatomic) NSBundle *appLanguageBundle;
@end

@implementation FeedbackViewController

-(void) networkAlert:(NSString*)message{
  UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Ошибка"
                                                  message:message
                                                 delegate:nil
                                        cancelButtonTitle:kAlertMsgButtonOkText
                                        otherButtonTitles: nil];
  [alert show];
}

#pragma mark -
#pragma mark - Network events

- (void)onNetworkEvent:(NSNotification *)notification {

  
  }

#pragma mark -
#pragma mark - REGISTER events

- (void)onRegistrationEvent:(NSNotification *)notification {
  }

#pragma mark -
#pragma mark - INVITE (audio/video, file transfer, chat, ...) events

- (void)onInviteEvent:(NSNotification *)notification {
  
  }

- (BOOL) queryConfigurationAndRegister{
  
    return true;
}

- (void)dealloc {
 
}

- (void)viewDidLoad {
  [super viewDidLoad];
  
  UIFont *NavigationBarFont = [UIFont fontWithName:@"PTSans-Bold" size:17.0];
  
  NSString *defaultLanguage = [[NSUserDefaults standardUserDefaults] stringForKey:@"appLanguage"];
  NSString *langPath = [[NSBundle mainBundle] pathForResource:defaultLanguage ofType:@"lproj"];
  NSBundle *appLanguageBundle = [NSBundle bundleWithPath: langPath];
  
  UILabel *titleLabel = [[UILabel alloc] initWithFrame: CGRectMake(0, 0, 150, 36)];
  titleLabel.text = [appLanguageBundle localizedStringForKey:@"menu.feedback" value:@"???" table:@"Localization"];
  titleLabel.textAlignment = NSTextAlignmentCenter;
  titleLabel.font = NavigationBarFont;
    titleLabel.textColor = [UIColor whiteColor];
  self.navigationItem.titleView = titleLabel;
  
  UIImage *menuIcon = [UIImage imageNamed: @"menu_icon"];
  _menuButton = [[UIButton alloc] initWithFrame:CGRectMake(0, 0, menuIcon.size.width, menuIcon.size.height)];
  
  [_menuButton setImage:menuIcon forState: UIControlStateNormal];
  [_menuButton setImage:[UIImage imageNamed: @"menu_icon_highlighted"] forState: UIControlStateHighlighted];
  
  [_menuButton addTarget:self action: @selector(menuButton_TouchUpInside:) forControlEvents: UIControlEventTouchUpInside];
  
  self.navigationItem.leftBarButtonItem = [[UIBarButtonItem alloc] initWithCustomView: _menuButton];
  
  if ([UIDevice currentDevice].userInterfaceIdiom == UIUserInterfaceIdiomPad) {
    
    _menuButton.enabled = !UIInterfaceOrientationIsLandscape([UIApplication sharedApplication].statusBarOrientation);
    _menuButton.hidden = UIInterfaceOrientationIsLandscape([UIApplication sharedApplication].statusBarOrientation);
  }
  
  Reachability *reachability = [Reachability reachabilityForInternetConnection];
  [reachability startNotifier];
  
  NetworkStatus status = [reachability currentReachabilityStatus];
  
  if (status == NotReachable) {
    _supportButton.enabled = NO;
    _repairButton.enabled = NO;
//    [appLanguageBundle localizedStringForKey:@"menu.feedback" value:@"???" table:@"Localization"];
    [[[UIAlertView alloc] initWithTitle:@"Ошибка" message:@"Вызов не доступен из-за отсутствия сети" delegate:nil cancelButtonTitle:@"Ok" otherButtonTitles:nil] show];
  } else {
    
    dispatch_async(dispatch_get_global_queue(0, 0), ^{
      
          });
    
    //    [[NgnEngine sharedInstance] start];
    
  }
}

- (void)viewWillAppear:(BOOL)animated {
  [super viewWillAppear:animated];
  
  [self localizable];
  
  if (UIInterfaceOrientationIsLandscape([UIApplication sharedApplication].statusBarOrientation)) {
    _menuButton.enabled = false;
    _menuButton.hidden = true;
  } else {
    _menuButton.enabled = true;
    _menuButton.hidden = false;
  }
  
  
  
  //	self.title = [KTAppLanguage string:STRING_KEY_FEEDBACK];
  //
  //	[_supportButton setTitle:[KTAppLanguage string:STRING_KEY_SUPPORT_CENTER] forState:UIControlStateNormal];
  //	[_repairButton setTitle:[KTAppLanguage string:STRING_KEY_REPAIR] forState:UIControlStateNormal];
  //
  //	if ([KTAppLanguage isRussian]) {
  //		[_supportButton setTitleEdgeInsets:UIEdgeInsetsMake(0.0f, 0.0f, 0.0f, 10.0f)];
  //		[_repairButton setTitleEdgeInsets:UIEdgeInsetsMake(0.0f, 0.0f, 0.0f, 0.0f)];
  //	} else if ([KTAppLanguage isEnglish]) {
  //		[_supportButton setTitleEdgeInsets:UIEdgeInsetsMake(0.0f, 0.0f, 0.0f, 34.0f)];
  //		[_repairButton setTitleEdgeInsets:UIEdgeInsetsMake(0.0f, 8.0f, 0.0f, 0.0f)];
  //	} else {
  //		[_supportButton setTitleEdgeInsets:UIEdgeInsetsMake(0.0f, 34.0f, 0.0f, 0.0f)];
  //		[_repairButton setTitleEdgeInsets:UIEdgeInsetsMake(0.0f, 26.0f, 0.0f, 0.0f)];
  //	}
}

- (void)willAnimateRotationToInterfaceOrientation:(UIInterfaceOrientation)toInterfaceOrientation duration:(NSTimeInterval)duration {
  [super willAnimateRotationToInterfaceOrientation:toInterfaceOrientation duration:duration];
  
  _menuButton.enabled = !UIInterfaceOrientationIsLandscape(toInterfaceOrientation);
  _menuButton.hidden = UIInterfaceOrientationIsLandscape(toInterfaceOrientation);
  
  
  UIViewController *rvc = self.navigationController.parentViewController;
  [rvc performSelector:@selector(closeSideViewControllerAnimated:completion:) withObject:@NO withObject:nil];
}

- (void)localizable {
  NSString *defaultLanguage = [[NSUserDefaults standardUserDefaults] stringForKey:@"appLanguage"];
  NSString *langPath = [[NSBundle mainBundle] pathForResource:defaultLanguage ofType:@"lproj"];
  _appLanguageBundle = [NSBundle bundleWithPath: langPath];
  
  _subtitleLabel.text =  [_appLanguageBundle localizedStringForKey:@"feedback.support_call" value:@"???" table:@"Localization"];
  _button1DescriptionLabel.text = [_appLanguageBundle localizedStringForKey:@"feedback.customer_support_center" value:@"???" table:@"Localization"];
  _button2DescriptionLabel.text = [_appLanguageBundle localizedStringForKey:@"feedback.central_repair_bureau" value:@"???" table:@"Localization"];
}


#pragma mark - segue

- (IBAction)buttonPressed:(id)sender {
    
    if ([_supportButton isEqual:sender]) {
        NSURL *url = [[NSURL alloc] initWithString:@"tel://\(160)"];
        [[UIApplication sharedApplication] openURL:url];
    } else {
        NSURL *url = [[NSURL alloc] initWithString:@"tel://\(165)"];
        [[UIApplication sharedApplication] openURL:url];
    }

  /*if ([[NgnEngine sharedInstance].networkService isReachable]) {
    UIStoryboard *storyboard = self.storyboard;
    KTAudioCallViewController *audioCallViewController = [storyboard instantiateViewControllerWithIdentifier:@"KTAudioCallViewController"];
    if ([_supportButton isEqual:sender]) {
      audioCallViewController.remoteNumber = @"160";
      audioCallViewController.dtmfUrlString = @"https://www.dropbox.com/s/ik7fvm4aya901tm/160.json?dl=1";
    } else {
      audioCallViewController.remoteNumber = @"165";
      audioCallViewController.dtmfUrlString = @"https://www.dropbox.com/s/8hd703ep2fvbvui/165.json?dl=1";
    }
    
    [self presentViewController:audioCallViewController animated:YES completion:nil];
    
  } else {
    UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:[_appLanguageBundle localizedStringForKey:@"error" value:@"???" table:@"Localization"] message:[_appLanguageBundle localizedStringForKey:@"feedback.check_internet_link" value:@"???" table:@"Localization"] delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
    [alertView show];
  }*/
}

- (void)openLeftSideViewControllerAnimated:(id)sender {
  
  //  rvc.openLeftSideViewControllerAnimated(true, completion: nil)
  PZSideMenuViewController *rvc = (PZSideMenuViewController *) self.navigationController.parentViewController;
  [rvc openLeftSideViewControllerAnimated:true completion:^{
    
  }];
}

- (IBAction)menuButton_TouchUpInside:(UIButton *)sender {
  [self openLeftSideViewControllerAnimated:sender];
  //  let rvc = self.navigationController!.parentViewController! as! RootViewController
  //  rvc.openLeftSideViewControllerAnimated(true, completion: nil)
  
  //  UIViewController *rvc = self.navigationController.parentViewController;
  //  rvc.openLeftSideViewControllerAnimated(true, completion: nil)
  //  [rvc performSelector:@selector(openLeftSideViewControllerAnimated:) withObject:@YES withObject:nil];
  //	rvc.openLeftSideViewControllerAnimated(true, completion: nil)
}

@end
