//
//  IdPhoneViewController.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 12.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class IdPhoneViewController: ViewControllerWithMenu, UIWebViewDelegate {
    @IBOutlet weak var webView: UIWebView!
    
    override func configureRightIndicator() {
        loadingIndicator = UIActivityIndicatorView(activityIndicatorStyle: .Gray)
        loadingIndicator?.color = .whiteColor()
        loadingIndicator!.hidesWhenStopped = true
        navigationItem.rightBarButtonItem = UIBarButtonItem(customView: loadingIndicator!)
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        configureRightIndicator()
        loadingIndicator?.startAnimating()
        configureBlueNavbar()
        webView.delegate = self
        ////  http://telecom.kz/headertest
        //    mutableRequest.addValue("\(Facade.clientId!)", forHTTPHeaderField: "mclientid")
        //    mutableRequest.addValue(Facade.accessToken!, forHTTPHeaderField: "maccesstoken")
        
        //    ?mclientid=e6c52e77d0536c97fd50d0cec0b6ae0a&maccesstoken=RZEAAOZGTXVTCBVKIVOBPRVHKSRSPUWQFCIMDEPMHQOWEPJCJQRCUQSCSVTQJVWYADGFGKXPLDYUHFKTJIVKLOSXYBCMZLKHUUCKAGSUTPXBWCVBEOAUJPVYFJSFWIWG&mserverid=17&mabonentid=2504444
        self.webView.loadRequest(NSURLRequest(URL: NSURL(string: "https://telecom.kz/account/idphone/user/profile?mclientid=\(Facade.clientId!)&maccesstoken=\(Facade.accessToken!)&mserverid=\(Facade.serverId!)&mabonentid=\(Facade.accountId!)")!))
        //    https://telecom.kz/account/idphone/services/profile
    }
}

// UIWebViewDelegate
extension IdPhoneViewController {
    func webView(webView: UIWebView, shouldStartLoadWithRequest request: NSURLRequest, navigationType: UIWebViewNavigationType) -> Bool {
        return true
        //    let inIframe = !self.doesRequest(request, webView: webView)
        //    let fromUserInteraction = (navigationType == UIWebViewNavigationType.LinkClicked || navigationType == UIWebViewNavigationType.FormSubmitted)
        //    print("inIFrame: \(inIframe) fromUserInteraction: \(fromUserInteraction)")
        //    print("all headers: \(request.allHTTPHeaderFields!)")
        //
        //    let mutableRequest = NSMutableURLRequest(URL: request.URL!)
        //    mutableRequest.addValue("\(Facade.clientId!)", forHTTPHeaderField: "mclientid")
        //    mutableRequest.addValue(Facade.accessToken!, forHTTPHeaderField: "maccesstoken")
        //    mutableRequest.HTTPMethod = request.HTTPMethod!
        //
        //    let containToken = request.allHTTPHeaderFields!.keys.contains("mclientid") && request.allHTTPHeaderFields!.keys.contains("maccesstoken")
        //
        //    if (!containToken) {
        //      webView.loadRequest(mutableRequest)
        //    }
        //
        //    return containToken
    }
    
    func doesRequest(request: NSURLRequest, webView: UIWebView) -> Bool {
        // sees if the mainDocumentURL of the request matches that of the webView
        // if not, is probably from an iFrame
        if let reqMainDocUrl = request.mainDocumentURL, let webViewMainDocUrl = webView.request?.mainDocumentURL {
            return reqMainDocUrl.absoluteString!.compare(webViewMainDocUrl.absoluteString!) == NSComparisonResult.OrderedSame
        }
        return false
    }
    
    func webViewDidFinishLoad(webView: UIWebView) {
        print("webViewDidFinishLoad")
        loadingIndicator?.stopAnimating()
    }
    
    func webViewDidStartLoad(webView: UIWebView) {
        print("webViewDidStartLoad")
    }
    
    func webView(webView: UIWebView, didFailLoadWithError error: NSError) {
        print("didFailLoadWithError")
    }
}
