//
//  ViewController.swift
//  kt
//
//  Created by Alexandr Zalutskiy on 15.01.15.
//  Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import UIKit

class RootViewController: SideMenuViewController {
    
    override func viewDidLoad() {
        
        debugPrint("RootViewController viewDidLoad begin")
        
        //    var vc : UIViewController?
        //    let cvc = LoginViewController(nibName: nil, bundle: nil)
        //    vc = UINavigationController(rootViewController: cvc)
        //
        //    centerViewController = vc
        
        centerViewController = self.storyboard!.instantiateViewControllerWithIdentifier(CabinetControllerId)
        leftViewController = self.storyboard!.instantiateViewControllerWithIdentifier(MenuControllerId)
        
        if Facade.accessToken == nil || Facade.clientId == nil {
            switch UIDevice.currentDevice().userInterfaceIdiom {
            case .Pad:
                (self.parentViewController as! UISplitViewController).view.hidden = true
                break
            default:
                break
            }
        }
        edgeOffset = UIOffset(horizontal: view.frame.width, vertical: 0)
        super.viewDidLoad()
        debugPrint("RootViewController viewDidLoad end")
    }
    
    override func viewWillLayoutSubviews() {
        super.viewWillLayoutSubviews()
        debugPrint("RootViewController viewWillLayoutSubviews begin")
        if Facade.accessToken == nil || Facade.clientId == nil {
            switch UIDevice.currentDevice().userInterfaceIdiom {
            case .Pad:
                let vc = self.storyboard!.instantiateViewControllerWithIdentifier("iPhoneRootViewController")
                presentViewController(vc, animated: false, completion: { () -> Void in
                    (self.parentViewController as! UISplitViewController).view.hidden = false
                })
                break
            default:
                break
            }
        }
        debugPrint("RootViewController viewWillLayoutSubviews end")
    }
    
    override func viewDidAppear(animated: Bool) {
        super.viewDidAppear(animated)
    }
    
    override func viewWillAppear(animated: Bool) {
        super.viewWillAppear(animated)
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
    override func shouldAutorotate() -> Bool {
        if UIDevice.currentDevice().userInterfaceIdiom == .Phone {
            return false
        } else {
            return true
        }
    }
}

