//
//  AppealHistoryPickerTableViewCell.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 27.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class AppealHistoryPickerTableViewCell : UITableViewCell {
  var isObserving = false
  @IBOutlet weak var titleLabel: UILabel!
  @IBOutlet weak var datePicker: UIDatePicker!
  class var expandedHeight: CGFloat { get { return 200 } }
  class var defaultHeight: CGFloat  { get { return 44  } }
  
  func checkHeight() {
    datePicker.hidden = frame.size.height < AppealHistoryPickerTableViewCell.expandedHeight
  }
  
  func watchFrameChanges() {
    if !isObserving {
      addObserver(self, forKeyPath: "frame", options: [NSKeyValueObservingOptions.New, NSKeyValueObservingOptions.Initial], context: nil)
      isObserving = true
    }
  }
  
  func ignoreFrameChanges() {
    if isObserving {
      removeObserver(self, forKeyPath: "frame")
      isObserving = false
    }
  }
  
  override func observeValueForKeyPath(keyPath: String?, ofObject object: AnyObject?, change: [String : AnyObject]?, context: UnsafeMutablePointer<Void>) {
    if keyPath == "frame" {
      checkHeight()
    }
  }
}
