//
// Created by Alexander Zalutskiy on 10.08.15.
// Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import UIKit

protocol CPanelData {
  var name: String { get }
  var hasActions: Bool { get }
  var actionsTitles: [String]? { get }
}

protocol CPanelTableViewCellDelegate: NSObjectProtocol {
  func wasSelectActionWithIndex(index: Int)
}

class CPanelTableViewCell: UITableViewCell {
  // MARK: Outlets
  @IBOutlet private weak var _titleLabel: UILabel!
  @IBOutlet private weak var _actionsButton: UIButton!

  // MARK: public property
  weak var delegate: CPanelTableViewCellDelegate?

  // MARK: private property
  var _data: CPanelData!

  // MARK: setters
  func setData(data: CPanelData) {
    _data = data

    _titleLabel.text = data.name
    _actionsButton.hidden = !data.hasActions
  }

  // MARK: Actions
  @IBAction func actionsButton_TouchUpInside(sender: AnyObject?) {
    let actionSheet = UIActionSheet(title: nil, delegate: self, cancelButtonTitle: §"cancel",
        destructiveButtonTitle: nil)

    for title in _data.actionsTitles! {
      actionSheet.addButtonWithTitle(title)
    }

    actionSheet.showInView(self)
  }
}

// MARK: - UIActionSheetDelegate
extension CPanelTableViewCell: UIActionSheetDelegate {

}