//
//  OnlinePaymentButtonFieldCell.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 19.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class OnlinePaymentButtonFieldCell : UITableViewCell, UITextFieldDelegate {
    
    @IBOutlet weak var leftButton: UIButton!
    @IBOutlet weak var rightButton: UIButton!
    @IBOutlet weak var titleLabel: UILabel!
    @IBOutlet weak var textField: UITextField!
    
    var textValue = ""
    
    private var _currentGuid: String?
    private var _currentPhone: String?
    
    var vc: OnlinePaymentViewController!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        textField.addTarget(self, action: #selector(OnlinePaymentButtonFieldCell.textChanged(_:)), forControlEvents: UIControlEvents.EditingChanged)
        textField.applyUITextFieldStyle()
        localizeSubviews()
        changedValue(isLeft: Facade.phoneNumber == nil)
        textField.setBottomBorder(Color.GrayTableCellSeparator)
    }
    
    func textChanged(textField: UITextField) {
        vc.params[textValue] = textField.text
    }
    
    func fillCell(textValue: String, vc: OnlinePaymentViewController) {
        self.vc = vc
        textField.delegate = self.vc
        self.textValue = textValue
        vc.params[textValue] = textField.text
    }
    
    private func localizeSubviews() {
        leftButton.setTitle(LS("online_payment.guid_cash_caps"), forState: .Normal)
        titleLabel.text = LS("online_payment.or")
        rightButton.setTitle(LS("online_payment.phone"), forState: .Normal)
    }
    
    @IBAction func leftButton_touchUpInside(sender: UIButton) {
        clickedButton(isLeft: true)
    }
    
    @IBAction func rightButton_touchUpInside(sender: UIButton) {
        clickedButton(isLeft: false)
    }
    
    private func saveCurrentValue(isLeft: Bool) {
        if isLeft {
            _currentPhone = textField.text
        } else {
            _currentGuid = textField.text
        }
    }
    
    private func clickedButton(isLeft isLeft: Bool) {
        saveCurrentValue(isLeft)
        changedValue(isLeft: isLeft)
    }
    
    private func changedValue(isLeft isLeft: Bool) {
        OnlinePaymentViewController.currentPayType = isLeft ? "guid" : "phone"
        textField.placeholder = isLeft ? LS("online_payment.guid_cash_caps") : ""
        if isLeft {
            textField.text = _currentGuid != nil ? _currentGuid! : OnlinePaymentViewController.guidOrPhone != nil ? OnlinePaymentViewController.guidOrPhone! : Facade.guid
            textField.tag = 100
        } else {
            textField.text = _currentPhone != nil ? _currentPhone! : OnlinePaymentViewController.guidOrPhone != nil ? OnlinePaymentViewController.guidOrPhone! :  Facade.phoneNumber != nil ? Facade.phoneNumber : ""
            textField.tag = 101
        }
        KeyboardUtil.changeKeyboardType(isLeft ? .Default : .PhonePad, textField: self.textField, leftViewRightMargin: 3)
        rightButton.setTitleColor(isLeft ? nil : Color.ButtonGrayColor, forState: .Normal)
        leftButton.setTitleColor(isLeft ? Color.ButtonGrayColor : nil, forState: .Normal)
        //    OnlinePaymentViewController.guidOrPhone = textField.text!
    }
    
}

// UITextFieldDelegate
extension OnlinePaymentButtonFieldCell {
    
    func textFieldDidBeginEditing(textField: UITextField) {
        //    activeField = textField
        textField.setBottomBorder(Color.BlueButtonColor)
    }
    
    func textFieldDidEndEditing(textField: UITextField) {
        //    activeField = nil
        textField.setBottomBorder(Color.GrayTableCellSeparator)
    }
    
    func textFieldShouldReturn(textField: UITextField) -> Bool {
        self.endEditing(true)
        return false
    }
}
