//
//  PaymentHistoryCell.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 19.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class PaymentHistoryCell : UITableViewCell {
    
    @IBOutlet weak var dateLabel: UILabel!
    @IBOutlet weak var moneyTypeNameLabel: UILabel!
    @IBOutlet weak var moneyLabel: UILabel!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        removeLeftMargin()
        moneyTypeNameLabel.textColor = Color.DarkColorForText
        moneyLabel.textColor = Color.DarkColorForText
    }
    
    func fillCell(payment: Payment) {
        if let date = payment.systemDate {
            dateLabel.text = date.getWithFormat("yyyy-MM-dd HH:mm")
        }
        moneyTypeNameLabel.text = payment.moneyTypeName
        moneyLabel.text = "\(payment.money!) \(LS("payments_history.tg"))"
    }
    
}
