//
//  PublishedCashPayCell.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 19.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class PublishedCashPayCell : UITableViewCell {
  @IBOutlet weak var leftResultLabel: UILabel!
  @IBOutlet weak var rightResultLabel: UILabel!
  @IBOutlet weak var paymentButton: NextButton!
  //  "cash_and_payments.label.out_money_about_cash" = "Итого по счету";
  
  override func awakeFromNib() {
    super.awakeFromNib()
    removeLeftMargin()
    leftResultLabel.textColor = Color.DarkColorForText
    rightResultLabel.textColor = Color.DarkColorForText
  }
  
  func fillCell(bill: Bill) {
    localizeSubviews()
    rightResultLabel.text = "\(bill.outMoney ?? "0")"
    paymentButton.setTitle("\(LS("published_cashes.pay_by_cash")) \(bill.outMoney ?? "0")", forState: .Normal)
  }
  
  private func localizeSubviews() {
    leftResultLabel.localizeWithParent(self, localizedId: "out_money_about_cash")
  }
  
  @IBAction func pay_touchUpInside(sender: UIButton) {
    //    if let balance = AbonentInfoManager.sharedInstance.abonentInfo!.balance {
    //      if balance >= 0 {
    //        AlertViewUtil.showIncorrectAlert(LS("online_payment.no_debts"))
    //      } else {
    (self.parentViewController as! PublishedCashesViewController).cashAndPaymentsViewController?.performSegueWithIdentifier("showPayment", sender: nil)
    //      }
    //    }
  }
}

extension PublishedCashPayCell: LocalizedParent {
  var localizedId: String {
    return "published_cashes"
  }
}
