//
//  ClaimTableCell.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 17.11.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class ClaimTableCell: UITableViewCell {
  @IBOutlet weak var firstLabel: UILabel!
  @IBOutlet weak var secondLabel: UILabel!
  @IBOutlet weak var thirdLabel: UILabel!
  
  override func awakeFromNib() {
    super.awakeFromNib()
    removeLeftMargin()
    secondLabel.textColor = Color.DashboardBlueColor
    firstLabel.textColor = Color.MyServicesCellGrayColor
    thirdLabel.textColor = Color.MyServicesCellGrayColor
  }
  
  func fillCell(fullDamage: FullDamage? = nil, claim: Claim? = nil, tabIndex: Int) {
    if tabIndex == 0 {
      firstLabel.setTextAndSizeToFit(fullDamage?.date ?? "")
      secondLabel.setTextAndSizeToFit("\(fullDamage?.assetNumber ?? "") \(fullDamage?.deviceGroup ?? "")")
      thirdLabel.setTextAndSizeToFit("\(fullDamage?.damageId ?? "")(\(fullDamage?.status ?? ""))")
    } else {
      firstLabel.setTextAndSizeToFit(claim?.date ?? "")
      secondLabel.setTextAndSizeToFit("\(claim?.assetNumber ?? "")")
      thirdLabel.setTextAndSizeToFit("\(claim?.claimId ?? "")(\(claim?.status ?? ""))")
    }
  }
}
