//
//  CallbackTextFieldCell.swift
//  kt
//
//  Created by Alexandr Zalutskiy on 02.02.15.
//  Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import UIKit

class CallbackTextFieldCell : UITableViewCell, UITextFieldDelegate {
  var vc: ServiceCallbackController!
  @IBOutlet weak var titleLabel: UILabel!
  @IBOutlet weak var textField: UITextField!
    
  var lblPrefix: UILabel?
  var textValue = ""
  var clickableCellValue: String = notClickableCell {
    didSet {
      if clickableCellValue == clickableCell {
        self.accessoryType = .DisclosureIndicator
      } else {
        //self.selectionStyle = .None
        self.accessoryType = .None
      }
    }
  }
  
    internal func RenderPrefix() {
        if (lblPrefix != nil && textField.text?.characters.count == 0) {
            lblPrefix?.textColor = Color.PlaceholderGrayColor
        } else {
            ShowPrefixAsBlackColor()
        }
    }
    
    internal func ShowPrefixAsBlackColor() {
        lblPrefix?.textColor = Color.TitleBlackColor
    }
    
  override func awakeFromNib() {
    super.awakeFromNib()
    textField.applyUITextFieldStyle()
    textField.addTarget(self, action: #selector(CallbackTextFieldCell.textChanged(_:)), forControlEvents: UIControlEvents.EditingChanged)
  }
  
  func textChanged(textField: UITextField) {
    vc.params[textValue] = textField.text
  }
  
    func fillDefaultValue() {
        if (textValue.characters.count > 0 && vc.params.count > 0) {
            let value = vc.params[textValue]
            if (value != nil) {
                textField.text = value as? String
            }            
        }
    }
    
  func cellSelected(vc: ServiceCallbackController, title: String) {
    vc.performSegueWithIdentifier("showOfferModal", sender: title)
  }
  
  func fillCell(text: String, vc: ServiceCallbackController, clickableCellValue: String) {
    textValue = text
    self.vc = vc
    textField.delegate = self.vc
    self.clickableCellValue = clickableCellValue
    titleLabel.localizeWithParent(self, localizedId: text)
    titleLabel.text = titleLabel.text?.uppercaseString
    switch text {
    case "full_name":
      textField.placeholder = LS("offer_callback.text_field.full_name.placeholder")
      break
    case "phone":
      lblPrefix = KeyboardUtil.changeKeyboardType(.PhonePad, textField: self.textField, leftViewRightMargin: 3)
      //self.textField.delegate = self;
      RenderPrefix()
      break
    case "city":
      textField.placeholder = LS("service_callback.text_field.city.placeholder")
      textField.userInteractionEnabled = false
      textField.text = vc.region?.text
      break
      case "email":
      textField.placeholder = "example@example.com"
    default:
      break
    }
  }
}

// UITextFieldDelegate
extension CallbackTextFieldCell {
  
    /*func textFieldShouldClear(textField: UITextField) -> Bool {
        self.textField.textColor = Color.PlaceholderGrayColor
        return true
    }
    */
    
    func textFieldShouldReturn(textField: UITextField) -> Bool {
    self.endEditing(true)
    return false
  }
}

extension CallbackTextFieldCell: LocalizedParent {
  var localizedId: String {
    return "service_callback"
  }
}
