//
//  FeedCollectionViewCell.swift
//  kt
//
//  Created by neox on 17.08.17.
//  Copyright © 2017 SimpleCode. All rights reserved.
//

import UIKit

class FeedCollectionViewCell: UICollectionViewCell {
    
    var id : Int? = 0
    
    @IBOutlet weak var image: UIImageView!
    
    @IBOutlet weak var title: UILabel!
    
    @IBOutlet weak var desc: UILabel!
    
    @IBOutlet weak var payButton: UIButtonRoundedBlue!
    
    var navController : UINavigationController?
    
    override func awakeFromNib() {
        super.awakeFromNib()
        let tap = UITapGestureRecognizer(target: self, action: #selector(FeedCollectionViewCell.tapFunction))
        payButton.addGestureRecognizer(tap)
    }
    
    func tapFunction(sender:UITapGestureRecognizer) {
        
        var serviceItem = ServiceItem()
        serviceItem.id = self.id
        serviceItem.type = "landing"
        serviceItem.name = self.title.text
        
        let storyboard = UIStoryboard(name: "Main", bundle: nil)
        let destination = storyboard.instantiateViewControllerWithIdentifier("ServiceItemScrollViewController") as! ServiceItemScrollViewController
        destination.serviceItemForLoading = serviceItem
        navController!.pushViewController(destination, animated: true)
    }
}
