//
//  UIButtonRoundedBlue.swift
//  kt
//
//  Created by Admin on 04.12.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

import Foundation
import UIKit

class UIButtonRoundedBlue: UIButton {
    
    override func awakeFromNib() {
        super.awakeFromNib()
        setTitleColor(.whiteColor(), forState: UIControlState.Normal)
        setTitleColor(.whiteColor(), forState: UIControlState.Highlighted)
        setTitleColor(.whiteColor(), forState: UIControlState.Selected)
        setTitleColor(.whiteColor(), forState: UIControlState.Disabled)
        setTitleColor(.whiteColor(), forState: UIControlState.Reserved)
        backgroundColor = Color.ButtonBlueDefaultColor
    }
    
    override var highlighted: Bool {
        didSet {
            backgroundColor = highlighted ? Color.ButtonBlueHighlightedColor : Color.ButtonBlueDefaultColor
        }
    }
}
