//
//  ServicePaymentTwoLabelCell.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 02.06.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class ServicePaymentTwoLabelCell: UITableViewCell, UITextFieldDelegate {
  @IBOutlet weak var firstLabel: UILabel!
  @IBOutlet weak var secondLabel: UILabel!
  @IBOutlet weak var textField: UITextField!
  var vc: PaymentForProviderViewController!
  var title: String = ""
  override func awakeFromNib() {
    super.awakeFromNib()
    textField.addTarget(self, action: #selector(ServicePaymentTwoLabelCell.textChanged(_:)), forControlEvents: UIControlEvents.EditingChanged)
    textField.applyUITextFieldStyle()
    textField.delegate = self
    removeLeftMargin()
  }

  func textChanged(textField: UITextField) {
    vc.params[title] = textField.text
  }
  
  func fillCell(title: String, vc: PaymentForProviderViewController) {
    self.vc = vc
    self.title = title
    self.firstLabel.text = vc.provider?.contractmask
    self.secondLabel.localizeWithParent(self, localizedId: title)
    selectionStyle = UITableViewCellSelectionStyle.None
  }
}

// UITextFieldDelegate
extension ServicePaymentTwoLabelCell {
  
  func textFieldShouldReturn(textField: UITextField) -> Bool {
    self.endEditing(true)
    return false
  }
}

extension ServicePaymentTwoLabelCell: LocalizedParent {
  var localizedId: String {
    return "service_payment"
  }
}
