//
//  UILabel+HTML.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 07.02.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

extension UILabel {
  func jaq_setHTMLFromString(attr: String, fontSize: CGFloat = 17, textColor: UIColor? = nil) {
    //    attr = attr.stringByAppendingString(NSString(format: "<style>body{font-family: '%@'; font-size:%fpx;}</style>", "PTSans-bold", font.pointSize) as String)
    var convertedAttr = attr.stringByAppendingString(NSString(format: "<style>body{font-size:%fpx;}</style>", fontSize) as String)
    var attrText = try! NSMutableAttributedString(data: convertedAttr.dataUsingEncoding(NSUTF8StringEncoding)!,
                                                  options: [NSDocumentTypeDocumentAttribute: NSHTMLTextDocumentType, NSCharacterEncodingDocumentAttribute: NSUTF8StringEncoding], documentAttributes: nil)
    if let textColor = textColor {
      attrText.addAttributes([NSForegroundColorAttributeName: textColor], range: NSMakeRange(0, attrText.length))
    }
    self.attributedText = attrText
  }
  
  func link(attr: String, link: String) {
    let ahref = "<a href=\"\(link)\">\(attr)</a>"
    self.attributedText = try! NSMutableAttributedString(data: ahref.dataUsingEncoding(NSUTF8StringEncoding)!,
                                                         options: [NSDocumentTypeDocumentAttribute: NSHTMLTextDocumentType, NSCharacterEncodingDocumentAttribute: NSUTF8StringEncoding], documentAttributes: nil)
  }
}
