//
//  Device.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 23.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

enum DeviceContextMenu {
    case TypeHasInternetSettings
    case TypeHasNoSettings
    case AltelDevice
    case Megogo
    case IDTV
}

class Device {
    var deviceGroupName: String?
    var deviceGroupId: String?
    var connectTypeId: String?
    var connectTypeName: String?
    var tariffPlanName: String?
    var device: String?
    var phone: Int?
    var linkId: String?
    var deviceServices: [DeviceService] = []
    var type: DeviceContextMenu = DeviceContextMenu.TypeHasNoSettings
    var url : String?
    var isIdTv : Bool? = false
    
    class DeviceService {
        var serviceId: String?
        var serviceName: String?
        var tariffPlanId: String?
        var tariffPlanName: String?
        var serviceCount: String?
        var connectTypeId: String?
        var deviceGroupName : String?
        
        
        init(json: JSON) {
            self.serviceId = json["service_id"].string
            self.serviceName = json["service_name"].string
            self.tariffPlanId = json["tariff_plan_id"].string
            self.tariffPlanName = json["tariff_plan_name"].string
            self.serviceCount = json["service_count"].string
        }
    }
    
    func isIdTV() -> Bool {
        return isIdTv != nil && isIdTv == true
    }
    
    init() {
        
    }
    
    init(deviceGroupName: String?, connectTypeId: String?, connectTypeName: String?, tariffPlanName: String?, device: String?, phone: Int?, type: DeviceContextMenu = DeviceContextMenu.TypeHasNoSettings, linkId: String?) {
        self.deviceGroupName = deviceGroupName
        self.connectTypeId = connectTypeId
        self.connectTypeName = connectTypeName
        self.tariffPlanName = tariffPlanName
        self.device = device
        self.phone = phone
        self.type = type
        self.linkId = linkId
    }
    
    init(json: JSON) {
        self.deviceGroupName = json["device_group_name"].string == nil ? "" : json["device_group_name"].string!.uppercaseString
        self.deviceGroupId = json["device_group_id"].string
        self.connectTypeName = json["connect_type_name"].string
        self.tariffPlanName = json["tariff_plan_name"].string
        self.phone = json["phone"].int
        self.device = json["device"].string
        self.linkId = json["link_id"].string
        self.connectTypeId = json["connect_type_id"].string
        self.isIdTv = json["idtv"].bool
        for subJson in json["services"].arrayValue {
            self.deviceServices.append(DeviceService(json: subJson))
        }
    }
}
