//
//  Payment.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 19.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class Payment {
    var reporDateId: Int?
    var systemDate: NSDate?
    var moneyTypeId: Int?
    var money: Double?
    var moneyTypeName: String?
    
    init(json: JSON) {
        self.reporDateId = json["report_date_id"].intValue
        let dateFormatter = NSDateFormatter()
        dateFormatter.locale = NSLocale(localeIdentifier: "en_US_POSIX")
        dateFormatter.dateFormat = "yyyy-MM-dd HH:mm"
        //    dateFormatter.timeZone = NSTimeZone(forSecondsFromGMT: 0)
        self.systemDate = dateFormatter.dateFromString(json["system_date"].stringValue)
        self.moneyTypeId = json["money_type_id"].intValue
        self.money = json["money"].doubleValue
        self.moneyTypeName = json["money_type_name"].stringValue
    }
    
    func dateAndMonthFormat() -> String? {
        guard let systemDate = systemDate else {
            return nil
        }
        let components = systemDate.getComponents()
        let year =  components.year
        let month = components.month
        let dateFormatter = NSDateFormatter()
        dateFormatter.locale = AppLocalization.language().locale
        //    if #available(iOS 9.0, *) {
        return "\(dateFormatter.standaloneMonthSymbols[month - 1].localizedCapitalizedString) \(year)"
        //    } else {
        // Fallback on earlier versions
        //    }
    }
    
}
