//
//  BotViewController.swift
//  kt
//
//  Created by neox on 12.07.17.
//  Copyright © 2017 SimpleCode. All rights reserved.
//

import UIKit

class BotViewController: UIViewController {
    
    @IBOutlet weak var messageField: UITextField!
    @IBOutlet weak var tableView: UITableView!
    @IBOutlet weak var circleButton: UIView!
    
    weak var activeField: UITextField?
    
    var messagesList : [BotResult] = []
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.circleButton.layer.cornerRadius = 25
        self.tableView.rowHeight = UITableViewAutomaticDimension
        self.tableView.estimatedRowHeight = 44
        self.tableView.separatorColor = UIColor.clearColor()
        self.navigationItem.title = "Консультант"
        let tap = UITapGestureRecognizer(target: self, action: #selector(BotViewController.sendButtonTap))
        self.circleButton.userInteractionEnabled = true
        self.circleButton.addGestureRecognizer(tap)
        NSNotificationCenter.defaultCenter().addObserver(self, selector: #selector(BotViewController.keyboardWillShow(_:)), name: UIKeyboardWillShowNotification, object: nil)
        NSNotificationCenter.defaultCenter().addObserver(self, selector: #selector(BotViewController.keyboardWillHide(_:)), name: UIKeyboardWillHideNotification, object: nil)
        addMessage("Здравствуйте! Я Ваш помощник на сайте Казахтелеком. Постараюсь ответить на большинство Ваших вопросов.", type: 0)
    }
    
    func keyboardWillShow(notification: NSNotification) {
        if let keyboardSize = (notification.userInfo?[UIKeyboardFrameBeginUserInfoKey] as? NSValue)?.CGRectValue() {
            self.view.frame.origin.y -= keyboardSize.height
        }
    }
    
    func keyboardWillHide(notification: NSNotification) {
        if let keyboardSize = (notification.userInfo?[UIKeyboardFrameBeginUserInfoKey] as? NSValue)?.CGRectValue() {
            self.view.frame.origin.y += keyboardSize.height
        }
    }
    
    override func viewDidAppear(animated: Bool) {
        super.viewDidAppear(animated)
        messageField.setBottomBorder(Color.GrayTableCellSeparator)
    }
    
    override func viewWillDisappear(animated: Bool) {
        super.viewWillDisappear(animated)
        NSNotificationCenter.defaultCenter().removeObserver(self)
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
    
    func textFieldDidBeginEditing(textField: UITextField) {
        activeField = textField
        textField.setBottomBorder(Color.BlueButtonColor)
    }
    
    func textFieldDidEndEditing(textField: UITextField) {
        activeField = nil
        textField.setBottomBorder(Color.GrayTableCellSeparator)
    }
    
    func textFieldShouldReturn(textField: UITextField) -> Bool {
        textField.resignFirstResponder()
        self.tableView.scrollToBottom(true)
        return true
    }
    
    func addMessage(message: String, type: Int) {
        let botResult = BotResult()
        botResult.type = type
        let botNode = BotNode()
        botNode.text = message
        botNode.expanded = 0
        botNode.id = "0"
        botNode.formId = "0"
        var botNodes : [BotNode] = []
        botNodes.append(botNode)
        botResult.nodes = botNodes
        self.messagesList.append(botResult)
        self.tableView.reloadData()
    }
    
    func numberOfSectionsInTableView(tableView: UITableView) -> Int {
        return 1
    }
    
    func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return self.messagesList.count
    }
    
    func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
        if messagesList[indexPath.row].type == 0 {
            let cell = tableView.dequeueReusableCellWithIdentifier("BotLeftMessageCell", forIndexPath: indexPath) as! BotLeftMessageCell
            cell.bind(messagesList[indexPath.row].nodes)
            return cell
        } else {
            let cell = tableView.dequeueReusableCellWithIdentifier("BotRightMessageCell", forIndexPath: indexPath) as! BotRightMessageCell
            cell.bind(messagesList[indexPath.row].nodes)
            return cell
        }
    }
    
    func reloadTable() {
        self.tableView.reloadData()
    }
    
    func getChildNodes(id: Int) {
        Facade.sharedInstance().childBot(String(id), onSuccess: { (botResult) in
            if botResult.count != 0 {
                self.messagesList.append(botResult)
                self.tableView.reloadData()
            } else {
                self.addMessage("Извините, по вашему запросу ничего не нашлось", type: 0)
            }
            self.tableView.scrollToBottom(true)
        }) { (error) in
            AlertViewUtil.showErrorAlert(error, vc: self)
        }
    }
    
    func sendButtonTap(sender:UITapGestureRecognizer) {
        if messageField.text?.characters.count == 0 {
            return
        }
        addMessage(messageField.text!, type: 1)
        Facade.sharedInstance().askBot(messageField.text!, onSuccess: { (botResult) in
            if botResult.count != 0 {
                self.messagesList.append(botResult)
                self.tableView.reloadData()
            } else {
                self.addMessage("Извините, по вашему запросу ничего не нашлось", type: 0)
            }
            self.messageField.text = ""
            self.view.endEditing(true)
            self.tableView.scrollToBottom(true)
        }) { (error) in
            AlertViewUtil.showErrorAlert(error, vc: self)
        }
    }
}

extension UITableView {
    func scrollToBottom(animated: Bool = true) {
        let sections = self.numberOfSections
        let rows = self.numberOfRowsInSection(sections - 1)
        self.scrollToRowAtIndexPath(NSIndexPath(forRow: rows - 1, inSection: sections - 1), atScrollPosition: .Bottom, animated: true)
    }
}
