//
//  HelpViewController.swift
//  kt
//
//  Created by neox on 23.08.17.
//  Copyright © 2017 SimpleCode. All rights reserved.
//

import UIKit

class MainHelpViewController: ViewControllerWithMenu {
    
    @IBOutlet weak var botView: CardView!
    @IBOutlet weak var callbackView: CardView!
    @IBOutlet weak var feedbackView: CardView!
    @IBOutlet weak var knowEdgeView: CardView!
    @IBOutlet weak var youtubeView: CardView!
    
    override func viewDidLoad() {
        
        super.viewDidLoad()
        configureBlueNavbar()
        
        let botGesture = UITapGestureRecognizer(target: self, action:  #selector (self.botAction (_:)))
        botView.addGestureRecognizer(botGesture)
        
        let сallbackGesture = UITapGestureRecognizer(target: self, action:  #selector (self.callbackAction (_:)))
        callbackView.addGestureRecognizer(сallbackGesture)
        
        let feedbackGesture = UITapGestureRecognizer(target: self, action:  #selector (self.feedbackAction (_:)))
        feedbackView.addGestureRecognizer(feedbackGesture)
        
        let knowedgeGesture = UITapGestureRecognizer(target: self, action:  #selector (self.knowedgeAction (_:)))
        knowEdgeView.addGestureRecognizer(knowedgeGesture)
        
        let youtubeGesture = UITapGestureRecognizer(target: self, action:  #selector (self.youtubeAction (_:)))
        youtubeView.addGestureRecognizer(youtubeGesture)
        
    }
    
    func botAction(sender:UITapGestureRecognizer) {
        let storyBoard : UIStoryboard = UIStoryboard(name: "Main", bundle:nil)
        let vc = storyBoard.instantiateViewControllerWithIdentifier("BotViewController") as! BotViewController
        self.navigationController?.pushViewController(vc, animated: true)
    }
    
    func callbackAction(sender:UITapGestureRecognizer) {
        let vc = self.storyboard!.instantiateViewControllerWithIdentifier("CallbackViewController") as! CallbackViewController
        vc.service_id = 0
        vc.type = 0
        self.navigationController?.pushViewController(vc, animated: true)
    }
    
    func feedbackAction(sender:UITapGestureRecognizer) {
        let vc = self.storyboard!.instantiateViewControllerWithIdentifier("FeedBackViewController") as! FeedBackViewController
        self.navigationController?.pushViewController(vc, animated: true)
    }
    
    func knowedgeAction(sender:UITapGestureRecognizer) {
        let storyBoard : UIStoryboard = UIStoryboard(name: "Main", bundle:nil)
        let vc = storyBoard.instantiateViewControllerWithIdentifier("MainKnowedgeViewController") as! MainKnowedgeViewController
        self.navigationController?.pushViewController(vc, animated: true)
    }
    
    func youtubeAction(sender:UITapGestureRecognizer) {
        let storyBoard : UIStoryboard = UIStoryboard(name: "Main", bundle:nil)
        let vc = storyBoard.instantiateViewControllerWithIdentifier("VideoViewController") as! VideoViewController
        self.navigationController?.pushViewController(vc, animated: true)
    }
    
}
