//
//  PromisePaymentViewController.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 15.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class PromisePaymentViewController: UIViewController, UIPickerViewDelegate {
  @IBOutlet weak var paymentTitleLabel: UILabel!
  @IBOutlet weak var longSelectLabel: UILabel!
  @IBOutlet weak var durationButton: UIButton!
  var durationStrings: [String] = []
  var durationValues: [Int] = [1, 5]
  var timeLengthIndex: Int = 0 {
    didSet {
      durationButton.setTitle("\(durationStrings[timeLengthIndex])", forState: .Normal)
    }
  }
  var deviceSettingsVC: DeviceSettingsViewController?
  
  @IBAction func durationButton_touchUpInside(sender: UIButton) {
    let acp = ActionSheetMultipleStringPicker(title: "", rows: [self.durationStrings], initialSelection: [timeLengthIndex], doneBlock: {
      picker, values, indexes in
      //        values[0]
      print("values = \(values)")
      print("indexes = \(indexes)")
      dispatch_async(dispatch_get_main_queue()){
        self.timeLengthIndex = values[0] as! Int
      }
      return
      }, cancelBlock: { ActionMultipleStringCancelBlock in return }, origin: sender)
    
    acp.setDoneButton(UIBarButtonItem(title: LS("ok"), style: .Plain, target: self, action: Selector()))
    acp.setCancelButton(UIBarButtonItem(title: LS("cancel"), style: .Plain, target: nil, action: Selector()))
    acp.showActionSheetPicker()
  }
  
  func fillVars() {
    durationStrings = [LS("promise_payment.day"), LS("promise_payment.5_days")]
    durationButton.setTitle(durationStrings[0], forState: .Normal)
  }
  
  override func viewDidLoad() {
    super.viewDidLoad()
    fillVars()
    configureViews()
    configureBlueNavbar()
    localize()
    localizeSubviews()
    addBackButtonForModal(.whiteColor())
    navigationController?.navigationBar.tintColor = .whiteColor()
    navigationItem.rightBarButtonItem = UIBarButtonItem(title: LS("settings.save"), style: UIBarButtonItemStyle.Plain, target: self, action: #selector(PromisePaymentViewController.save_touchUpInside(_:)))
  }
  
  func configureViews() {
    paymentTitleLabel.textColor = Color.DarkColorForText
    longSelectLabel.textColor = Color.DarkColorForText
  }
  
  func save_touchUpInside(sender: UIBarButtonItem) {
    let params = [
      "access_token": Facade.accessToken!,
      "client_id": Facade.clientId!,
      "server_id": Facade.serverId!,
      "abonent_id": Facade.accountId!,
      "device": deviceSettingsVC!.device!.device!,
      "length": timeLengthIndex
      ] as [String: AnyObject]
    PKNotification.loading(true)
    self.view.userInteractionEnabled = false
    Facade.sharedInstance().savePromisedPayment(params, onSuccess: {
      self.deviceSettingsVC?.deviceSettings?.promisedPaymentStatus = 1
      self.deviceSettingsVC?.deviceSettings?.promisedPayment = self.deviceSettingsVC!.promisedPaymentFromStatus(1)
      self.deviceSettingsVC?.tableView.reloadData()
      self.dismissViewControllerAnimated(true, completion: nil)
    }, onError: { (error) in
      AlertViewUtil.showIncorrectAlert(error)
      }, onFinish:{ () in
        PKNotification.loading(false)
        self.view.userInteractionEnabled = true
    })
  }
  
  func localizeSubviews() {
    paymentTitleLabel.localizeWithParent(self, localizedId: "turn_on_promised_payment")
    longSelectLabel.localizeWithParent(self, localizedId: "long_selection")
  }
  
}

// UIPickerViewDelegate
extension PromisePaymentViewController {
  func numberOfComponentsInPickerView(pickerView: UIPickerView) -> Int {
    return 1
  }
  
  func pickerView(pickerView: UIPickerView, numberOfRowsInComponent component: Int) -> Int {
    return 2
  }
  
  func pickerView(pickerView: UIPickerView, titleForRow row: Int, forComponent component: Int) -> String? {
    switch row {
    case 0:
      return LS("promise_payment.day")
    case 1:
      return LS("promise_payment.5_days")
    default:
      return ""
    }
  }
  
  //  func pickerView(pickerView: UIPickerView, viewForRow row: Int, forComponent component: Int, reusingView view: UIView?) -> UIView {
  //    pickerView.subviews[1].hidden = true
  //    pickerView.subviews[2].hidden = true
  //    let label = UILabel()
  //    label.textAlignment = .Left
  //    label.font = UIFont.systemFontOfSize(15)
  //    label.text = AddNotificationPickerCell.distanceUnits[row][1]
  //    return label
  //  }
  
  func pickerView(pickerView: UIPickerView, didSelectRow row: Int, inComponent component: Int) {
    switch row {
    case 0:
      timeLengthIndex = 1
      break
    case 1:
      timeLengthIndex = 5
      break
    default: break
    }
    
  }
}

extension PromisePaymentViewController {
  override var localizedId: String {
    return "promise_payment"
  }
}
