//
//  FastPayItem.swift
//  kt
//
//  Created by Admin on 18.12.16.
//  Copyright © 2016 SimpleCode. All rights reserved.
//

import Foundation

class FastPayItem : NSObject, NSCoding  {
    
    internal var title : String = ""
    internal var phoneNumber : String = ""
    internal var uuid : String = ""
    
    init(title: String, phoneNumber : String) {
        self.title = title
        self.phoneNumber = phoneNumber
        self.uuid = NSUUID().UUIDString
        super.init()
    }
    
    func compare(payItem:FastPayItem) -> Bool {
        if payItem.uuid.compare(self.uuid) == .OrderedSame {
            return true
        }
        return false
    }
    
    @objc required init?(coder aDecoder: NSCoder) {
        title = aDecoder.decodeObjectForKey("title") as! String
        phoneNumber = aDecoder.decodeObjectForKey("phoneNumber")  as! String
        uuid = aDecoder.decodeObjectForKey("uuid")  as! String
    }
    
    @objc func encodeWithCoder(aCoder: NSCoder) {
        aCoder.encodeObject(title, forKey: "title")
        aCoder.encodeObject(phoneNumber, forKey: "phoneNumber")
        aCoder.encodeObject(uuid, forKey: "uuid")
    }
    
}
