//
//  PromoViewController.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 06.06.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class PromoViewController: UIViewController, UIScrollViewDelegate {
    
    @IBOutlet weak var scrollView: UIScrollView!
    @IBOutlet weak var bottomScrollView: UIScrollView!
    @IBOutlet weak var imageView: UIImageView!
    @IBOutlet weak var bottomView: UIView!
    @IBOutlet weak var bottomViewTitleLabel: UILabel!
    @IBOutlet weak var bottomViewDescriptionLabel: UILabel!
    @IBOutlet weak var pageControl: UIPageControl!
    @IBOutlet weak var okButton: BlueButton!
    var frame: CGRect = CGRectMake(0, 0, 0, 0)
    var close_touchUpInside: ((sender: UIButton) -> Void)?
    var pagesCount = 3
    var index: Int = 0
    
    @IBAction func ok_touchUpInside(sender: UIButton) {
        close_touchUpInside?(sender: sender)
        self.view.removeFromSuperview()
        self.removeFromParentViewController()
    }
    
    private func localizeSubviews() {
        okButton.setTitle("Ok", forState: .Normal)
    }
    
    override func viewWillAppear(animated: Bool) {
        super.viewWillAppear(animated)
        localizeSubviews()
    }
    
    private func configureSubviews() {
        bottomView.backgroundColor = Color.PromoBlueColor
    }
    
    private func configurePageControl() {
        self.pageControl.numberOfPages = pagesCount
        self.pageControl.currentPage = 0
        self.view.bringSubviewToFront(pageControl)
    }
    
    private func configureImageView(imageView: UIImageView) {
        imageView.contentMode = .ScaleAspectFill
        imageView.layer.shadowColor = UIColor.blackColor().CGColor
        imageView.layer.shadowOpacity = 0.7
        imageView.layer.shadowOffset = CGSize(width: 2, height: 2)
        imageView.layer.shadowRadius = 5
    }
    
    private func configureScrollViews() {
        for index in 0..<pagesCount {
            //      top ScrollView
            frame.origin.x = self.scrollView.frame.size.width * CGFloat(index)
            frame.size = self.scrollView.frame.size
            self.scrollView.pagingEnabled = true
            let imageWrapperView = UIView(frame: frame)
            let imageView = UIImageView(frame: frame)
            configureImageView(imageView)
            imageWrapperView.addSubview(imageView)
            imageView.translatesAutoresizingMaskIntoConstraints = false
            let views = ["image": imageView]
            imageWrapperView.addConstraints(NSLayoutConstraint.constraintsWithVisualFormat("H:|-40-[image]-40-|", options: [], metrics: nil, views: views))
            imageWrapperView.addConstraints(NSLayoutConstraint.constraintsWithVisualFormat("V:|-40-[image]|", options: [], metrics: nil, views: views))
            imageView.image = UIImage(named: "promo_\(index)")
            imageView.contentMode = .ScaleAspectFit
            self.scrollView.addSubview(imageWrapperView)
            
            //      bottom ScrollView
            let newFrame2 = CGRect(origin: CGPoint(x: self.bottomScrollView.frame.size.width * CGFloat(index), y: 0), size: self.bottomScrollView.frame.size)
            let descriptionView = PromoDescriptionView.instanceFromNib()
            descriptionView.frame = newFrame2
            descriptionView.titleLabel.setTextAndSizeToFit(LS("promo.title_\(index)"))
            descriptionView.descriptionLabel.setTextAndSizeToFit(LS("promo.description_\(index)"))
            self.bottomScrollView.pagingEnabled = true
            self.bottomScrollView.addSubview(descriptionView)
        }
        
        self.scrollView.contentSize = CGSizeMake(self.scrollView.frame.size.width * CGFloat(pagesCount), self.scrollView.frame.size.height)
        self.bottomScrollView.contentSize = CGSizeMake(self.bottomScrollView.frame.size.width * CGFloat(pagesCount), self.bottomScrollView.frame.size.height)
        pageControl.addTarget(self, action: #selector(PromoViewController.changePage(_:)), forControlEvents: UIControlEvents.ValueChanged)
        
    }
    
    // MARK : TO CHANGE WHILE CLICKING ON PAGE CONTROL
    func changePage(sender: UIPageControl) -> () {
        let xforTop = CGFloat(pageControl.currentPage) * scrollView.frame.size.width
        let xforBottom = CGFloat(pageControl.currentPage) * bottomScrollView.frame.size.width
        UIView.animateWithDuration(0.4, animations: {
            self.scrollView.contentOffset = CGPointMake(xforTop, 0)
            self.bottomScrollView.contentOffset = CGPointMake(xforBottom, 0)
        })
    }
    
    override func viewDidAppear(animated: Bool) {
        super.viewDidAppear(animated)
        configureScrollViews()
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        configureSubviews()
        configurePageControl()
    }
    
}

// UIScrollViewDelegate
extension PromoViewController {
    
    func scrollViewDidScroll(scrollView: UIScrollView) {
        if scrollView.isEqual(self.scrollView) {
            bottomScrollView.contentOffset = CGPoint(x: scrollView.contentOffset.x, y: bottomScrollView.contentOffset.y)
        } else {
            self.scrollView.contentOffset = CGPoint(x: bottomScrollView.contentOffset.x, y: self.scrollView.contentOffset.y)
        }
    }
    
    func scrollViewDidEndDecelerating(scrollView: UIScrollView) {
        let pageNumber = round(scrollView.contentOffset.x / scrollView.frame.size.width)
        pageControl.currentPage = Int(pageNumber)
    }
}
