//
//  ServiceTariffController.swift
//  kt
//
//  Created by Alexandr Zalutskiy on 31.01.15.
//  Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import UIKit

class ServiceTariffController: UIViewController, UITableViewDataSource, UITableViewDelegate {
    
    @IBOutlet weak var tableview: UITableView!
    
    var rate: ServiceItem.Rate!
    var tariff: Tariff!
    var serviceItem: ServiceItem!
    
    private let cellIdentifier = "tariffDetailCell"
    private let titleCellIdentifier = "tariffNameCell"
    
    // MARK: View life cicle
    
    override func viewWillAppear(animated: Bool) {
        super.viewWillAppear(animated)
        configureBlueNavbar()
        addBackButtonForDefault(.whiteColor())
        setRightTextButton(
            LocalizedString("service.connect", description: "Подключить"),
            target: self,
            selector: #selector(ServiceTariffController.connectButton_TouchUpInside(_:)), color: .whiteColor(), highlightedColor: UIColor.whiteColor().colorWithAlphaComponent(0.5))
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.tableview.estimatedRowHeight = 44.0;
        self.tableview.rowHeight = UITableViewAutomaticDimension;
        self.tableview.separatorStyle = .None
    }
    
    // MARK: UITableViewDataSource
    
    func numberOfSectionsInTableView(tableView: UITableView) -> Int {
        return 2
    }
    
    func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if section == 0 {
            return 1
        }
        return 1
    }
    
    func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
        switch indexPath.section {
        case 0:
            let cell = tableView.dequeueReusableCellWithIdentifier(titleCellIdentifier, forIndexPath: indexPath)
                as! TariffNameCell
            cell.tariffNameLabel.text = rate.name
            //			cell.tariffNameLabel.text = tariff.name
            //cell.selectionStyle = .None
            return cell
        default:
            let cell = tableView.dequeueReusableCellWithIdentifier(cellIdentifier, forIndexPath: indexPath) as! TariffDetailCell
            cell.tariffDetailValue.text = rate.price
            cell.tariffDetailTitle.text = LS("tariff.internet_speed").uppercaseString
            cell.tariffDescriptionValue.setTextAndSizeToFit(rate.desc)
            return cell
        }
        
    }
    
    // NARK: UITableViewDelegate
    
    func tableView(tableView: UITableView, heightForRowAtIndexPath indexPath: NSIndexPath) -> CGFloat {
        switch indexPath.section {
        case 0:
            return 44
        default:
            return 65
        }
    }
    
    // MARK: Actions
    
    func connectButton_TouchUpInside(sender: AnyObject) {
        let vc = self.storyboard!.instantiateViewControllerWithIdentifier("CallbackViewController") as! CallbackViewController
        vc.service_id = serviceItem?.id
        vc.type = 1
        self.navigationController?.pushViewController(vc, animated: true)
    }
    
    // MARK: Navigation
    
    override func prepareForSegue(segue: UIStoryboardSegue, sender: AnyObject?) {
        let vc = segue.destinationViewController as! ServiceCallbackController
        vc.serviceItem = serviceItem
        vc.type = 2
    }
}
