//
//  ProviderCategoriesViewController.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 02.06.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class ProviderCategoriesViewController : UIViewController, UITableViewDataSource, UITableViewDelegate {
  @IBOutlet var tableView: UITableView!
  let reuseCellIdentifier = "cell"
  var items: [[String]] = []
  var vc: ProvidersViewController?
  var type: String!
  
  override func viewDidLoad() {
    super.viewDidLoad()
    addBackButtonForModal(.whiteColor())
    configureBlueNavbar()
    configureTableView()
  }
  
  private func configureTableView() {
    tableView.rowHeight = UITableViewAutomaticDimension
    tableView.estimatedRowHeight = 60
  }
  
  override func viewWillAppear(animated: Bool) {
    super.viewWillAppear(animated)
    //    localize()
    tableView.reloadData()
  }
}

// UITableViewDataSource
extension ProviderCategoriesViewController {
  
  func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
    return items.count
  }
  
  func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
    let cell = tableView.dequeueReusableCellWithIdentifier(reuseCellIdentifier, forIndexPath: indexPath) as! SelectCityForProviderCell
    cell.fillCell(items[indexPath.row][1])
    //cell.selectionStyle = .None
    return cell
  }
}

// UITableViewDelegate
extension ProviderCategoriesViewController {
  func tableView(tableView: UITableView, didSelectRowAtIndexPath indexPath: NSIndexPath) {
    dismissViewControllerAnimated(false, completion: nil)
  }
}

extension ProviderCategoriesViewController {
  override var localizedId: String {
    return "select_city_for_provider"
  }
}
