//
//  SelectCardTypeViewController.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 02.06.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class SelectCardTypeViewController : UIViewController, UITableViewDataSource, UITableViewDelegate {
  @IBOutlet var tableView: UITableView!
  let reuseCellIdentifier = "cell"
  var vc: PaymentForProviderViewController!
  
  override func viewDidLoad() {
    super.viewDidLoad()
    addBackButtonForModal(.whiteColor())
    configureBlueNavbar()
    configureTableView()
  }
  
  private func configureTableView() {
    tableView.rowHeight = UITableViewAutomaticDimension
    tableView.estimatedRowHeight = 60
  }
  
  override func viewWillAppear(animated: Bool) {
    super.viewWillAppear(animated)
    tableView.reloadData()
  }
}

// UITableViewDataSource
extension SelectCardTypeViewController {
  
  func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
    return vc.cardTypes.count
  }
  
  func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
    let cell = tableView.dequeueReusableCellWithIdentifier(reuseCellIdentifier, forIndexPath: indexPath) as! ServiceCardTypeCell
    cell.fillCell(vc.cardTypes[indexPath.row].name)
    //cell.selectionStyle = .None
    return cell
  }
}

// UITableViewDelegate
extension SelectCardTypeViewController {
  func tableView(tableView: UITableView, didSelectRowAtIndexPath indexPath: NSIndexPath) {
    vc.selectedCardType = vc.cardTypes[indexPath.row]
    dismissViewControllerAnimated(false, completion: {
      self.vc.tableView.reloadData()
    })
  }
}

extension SelectCardTypeViewController {
  override var localizedId: String {
    return "select_card_type"
  }
}
