//
//  RBCreationButtonTableCell.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 26.11.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class RBCreationButtonTableCell: UITableViewCell {
  @IBOutlet weak var button: UIButton!
  var vc: RBCreationViewController!
  var key: String!
  
  override func awakeFromNib() {
    super.awakeFromNib()
    button.backgroundColor = Color.BlueButtonColor
  }
  
  func fillCell(key: String, vc: RBCreationViewController) {
    self.vc = vc
    self.key = key
    localizeViews()
  }
  
  func localizeViews() {
    button.setTitle(LS("claim_page_menu.label.create_repair_bureau_downcase"), forState: .Normal)
  }
  
  @IBAction func myButton_touchUpInside(sender: AnyObject) {
    if let phoneOrComment = vc.params["phone_or_comment"] as? String where !phoneOrComment.isEmpty  {
      if vc.claimCreationType! == .RB {
        let params: [String: AnyObject] = ["client_id": Facade.clientId!,
                                           "access_token": Facade.accessToken!,
                                           "server_id": Facade.serverId!,
                                           "abonent_id": Facade.accountId!,
                                           "asset_number": self.vc.selectedSiebelAccountData!.assetNumber ?? "",
                                           "asset_id": self.vc.selectedSiebelAccountData!.assetId ?? "",
                                           "comment": phoneOrComment,
                                           "damage_name": self.vc.currentDamageSource?.damageName ?? ""]
        self.vc.processRequest(true)
        Facade.sharedInstance().damageCreate(params, onSuccess: { (damages) in
          //print(damages)
            AlertViewUtil.showErrorAlert("", message: LS("claim_page_menu.label.rb_claim_created_successfully"), vc: self.vc, handler: {
                self.vc.closeWithCreatedItem()
            })
            
          }, onError: { (error) in
            AlertViewUtil.showMessageAlert(error, vc: self.vc)
          }, onFinish: { 
            self.vc.processRequest(false)
        })
      } else {
        let params: [String: AnyObject] = ["client_id": Facade.clientId!,
                                           "access_token": Facade.accessToken!,
                                           "server_id": Facade.serverId!,
                                           "abonent_id": Facade.accountId!,
                                           "asset_id": self.vc.selectedSiebelAccountData!.assetId ?? "",
                                           "comment": phoneOrComment,
                                           "type_name": self.vc.currentClaimSource.typeName ?? "",
                                           "sub_type_name": self.vc.currentClaimSubSource.subTypeName ?? "",
                                           "type_id": self.vc.currentClaimSource.typeId ?? ""]
        self.vc.processRequest(true)
        Facade.sharedInstance().siebelClaimCreate(params, onSuccess: { (siebelClaims) in
            AlertViewUtil.showErrorAlert("", message: "\(LS("claim_page_menu.label.sc_claim_created_successfully")) \n ID:\(siebelClaims[0].claimId ?? "")", vc: self.vc, handler: {
                self.vc.closeWithCreatedItem()
            })

          }, onError: { (error) in
            
            AlertViewUtil.showMessageAlert(error, vc: self.vc)
          }, onFinish: {
            self.vc.processRequest(false)
        })
      }
    } else {
      AlertViewUtil.showMessageAlert(LS("claim_page_menu.label.comment_field_cannot_be_blank"), vc: self.vc)
    }
    
  }
  
  @IBAction func button_touchUpInside(sender: UIButton) {
    //      "asset_id": "1-9H10-1533",
    //      "client_id": "f90c848a-fb39-47ee-b5af-e4fb5b86fc5d",
    //      "access_token": "ALYPZEELXFNWNRSYYGZJKIJYLTSPFYDRTPQZGDTOKQXFTFORXPNWHESMEQFFDHCRVDVTVLMJWWODNXPJIGLMCVDYGVEJLWFFTTYOQBAUMCZUCHVNXRSFDGPBYACGISPQ",
    //      "server_id": 17,
    //      "abonent_id": 2504444,
    //      "comment": "к",
    //      "type_name": "ServiceQual",
    //      "sub_type_name": "Grup",
    //      "type_id": "1-8D84"
    
    //accessToken: Facade.accessToken, clientId: Facade.clientId, serverId: Facade.serverId, abonentId: Facade.accountId
  }
}
