//
//  ActiveSessionsCell.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 22.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class ActiveSessionsCell: UITableViewCell {
    @IBOutlet weak var firstLeftLabel: UILabel!
    @IBOutlet weak var firstRightLabel: UILabel!
    @IBOutlet weak var secondLeftLabel: UILabel!
    @IBOutlet weak var secondRightLabel: UILabel!
    @IBOutlet weak var thirdLeftLabel: UILabel!
    @IBOutlet weak var thirdRightLabel: UILabel!
    @IBOutlet weak var dateLabel: UILabel!
    @IBOutlet weak var infoLabel: UILabel!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        removeLeftMargin()
        localizedSubviews()
    }
    
    private func localizedSubviews() {
        firstLeftLabel.localizeWithParent(self, localizedId: "ip_address")
        secondLeftLabel.localizeWithParent(self, localizedId: "packet_in")
        thirdLeftLabel.localizeWithParent(self, localizedId: "packet_out")
    }
    
    func fillCell(activeSession: ActiveSession) {
        dateLabel.text = activeSession.dateAndMonthFormat()
        infoLabel.text = activeSession.serviceInfo
        firstRightLabel.text = activeSession.framedIpAddress
        secondRightLabel.text = "\(activeSession.inputOctets! / 1048576)"
        thirdRightLabel.text = "\(activeSession.outputOctets! / 1048576)"
    }
    
}

extension ActiveSessionsCell: LocalizedParent {
    var localizedId: String {
        return "active_sessions"
    }
}
