//
//  KTButtonGray.swift
//  kt
//
//  Created by Admin on 04.12.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class UIButtonSquaredGray: UIButton {
    
    override func awakeFromNib() {
        super.awakeFromNib()
        self.layer.cornerRadius = 0
        setTitleColor(.whiteColor(), forState: UIControlState.Normal)
        setTitleColor(.whiteColor(), forState: UIControlState.Highlighted)
        setTitleColor(.whiteColor(), forState: UIControlState.Selected)
        setTitleColor(.whiteColor(), forState: UIControlState.Disabled)
        setTitleColor(.whiteColor(), forState: UIControlState.Reserved)
        backgroundColor = Color.ButtonGrayDefaultColor
    }
    
    override var highlighted: Bool {
        didSet {
            backgroundColor = highlighted ? Color.ButtonGrayHighlightedColor : Color.ButtonGrayDefaultColor
        }
    }
}
