//
//  Facade+AltelDevices.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 11.02.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

extension Facade {
  func getAltelDevices(onError: String -> Void, onSuccess: [Device] -> Void, onFinish: () -> Void) {
    let parameters = [
      "access_token": Facade.accessToken!,
      "client_id": Facade.clientId!,
      "server_id": Facade.serverId!,
      "abonent_id": Facade.accountId!,
      ] as [String: AnyObject]
    request(Router.AltelDevices(parameters)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      if let error = error {
        Router.globalLog.error(error.debugDescription)
        onError(error.localizedDescription)
      } else {
        Router.globalLog.debug(resp)
        var devices:[Device] = []
        for subJson in json.arrayValue {
          devices.append(Device(deviceGroupName: "Altel 4G", connectTypeId: nil, connectTypeName: "Мобильный телефон", tariffPlanName: nil, device: subJson.stringValue, phone: nil, type: DeviceContextMenu.AltelDevice, linkId: nil))
        } 
        onSuccess(devices)
      }
      onFinish()
    })
    //    get_abonent_device_list
  }
  
  func getAltelPeriods(onError: String -> Void, onSuccess: [AltelPeriod] -> Void) {
    let parameters = [
      "access_token": Facade.accessToken!,
      "client_id": Facade.clientId!,
      "server_id": Facade.serverId!,
      "abonent_id": Facade.accountId!,
      ] as [String: AnyObject]
    request(Router.AltelPeriodsList(parameters)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      if let error = error {
        Router.globalLog.error(error.debugDescription)
        onError(error.localizedDescription)
      } else {
        Router.globalLog.debug(resp)
        var altelPeriods:[AltelPeriod] = []
        for subJson in json.arrayValue {
          altelPeriods.append(AltelPeriod(periodId: subJson["oracle_id"].stringValue, name: subJson["name"].stringValue))
        }
        altelPeriods = altelPeriods.reverse()
        onSuccess(altelPeriods)
      }
    })
    //    get_abonent_device_list
  }

  func getAltelDetalization(params: [String: AnyObject], onError: String -> Void, onSuccess: [AltelDetalization] -> Void, onFinish: () -> Void) {
    request(Router.AltelDetalization(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      if let error = error {
        Router.globalLog.error(error.debugDescription)
        onError(error.localizedDescription)
      } else {
        Router.globalLog.debug(resp)
        var altelDetails:[AltelDetalization] = []
        for subJson in json.arrayValue {
          altelDetails.append(AltelDetalization(startTime: subJson["start_time"].stringValue, packetIn: subJson["packet_in"].doubleValue, packetOut: subJson["packet_out"].doubleValue, price: subJson["price"].doubleValue))
        }
        onSuccess(altelDetails)
      }
      onFinish()
    })
    //    get_abonent_device_list
  }
  
}
