//
//  OffersManager.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 30.10.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class OffersManager {
  var pointType: String? {
    set {
      NSUserDefaults.standardUserDefaults().setValue(newValue, forKey: "offers_point_type")
    }
    get {
      return NSUserDefaults.standardUserDefaults().valueForKey("offers_point_type") as? String
    }
  }
  var cityId:String? {
    set {
      NSUserDefaults.standardUserDefaults().setValue(newValue, forKey: "offers_city_id")
    }
    get {
      return NSUserDefaults.standardUserDefaults().valueForKey("offers_city_id") as? String
    }
  }
  var regionId: String? {
    set {
      NSUserDefaults.standardUserDefaults().setValue(newValue, forKey: "offers_region_id")
    }
    get {
      return NSUserDefaults.standardUserDefaults().valueForKey("offers_region_id") as? String
    }
  }
  var areaId:String? {
    set {
      NSUserDefaults.standardUserDefaults().setValue(newValue, forKey: "offers_area_id")
    }
    get {
      return NSUserDefaults.standardUserDefaults().valueForKey("offers_area_id") as? String
    }
  }
  var villageId: String? {
    set {
      NSUserDefaults.standardUserDefaults().setValue(newValue, forKey: "offers_village_id")
    }
    get {
      return NSUserDefaults.standardUserDefaults().valueForKey("offers_village_id") as? String
    }
  }
  var streetId:String? {
    set {
      NSUserDefaults.standardUserDefaults().setValue(newValue, forKey: "offers_street_id")
    }
    get {
      return NSUserDefaults.standardUserDefaults().valueForKey("offers_street_id") as? String
    }
  }
  var houseId:String? {
    set {
      NSUserDefaults.standardUserDefaults().setValue(newValue, forKey: "offers_house_id")
    }
    get {
      return NSUserDefaults.standardUserDefaults().valueForKey("offers_house_id") as? String
    }
  }
  var cities: [[String]]? {
    set {
      NSUserDefaults.standardUserDefaults().setObject(newValue, forKey: "offers_cities")
    }
    get {
      return NSUserDefaults.standardUserDefaults().objectForKey("offers_cities") as? [[String]]
    }
  }
  var areas: [[String]]? {
    set {
      NSUserDefaults.standardUserDefaults().setObject(newValue, forKey: "offers_areas")
    }
    get {
      return NSUserDefaults.standardUserDefaults().objectForKey("offers_areas") as? [[String]]
    }
  }
  var streets: [[String]]? {
    set {
      NSUserDefaults.standardUserDefaults().setObject(newValue, forKey: "offers_streets")
    }
    get {
      return NSUserDefaults.standardUserDefaults().objectForKey("offers_streets") as? [[String]]
    }
  }
  var houses: [[String]]? {
    set {
      NSUserDefaults.standardUserDefaults().setObject(newValue, forKey: "offers_houses")
    }
    get {
      return NSUserDefaults.standardUserDefaults().objectForKey("offers_houses") as? [[String]]
    }
  }
  var villages: [[String]]? {
    set {
      NSUserDefaults.standardUserDefaults().setObject(newValue, forKey: "offers_villages")
    }
    get {
      return NSUserDefaults.standardUserDefaults().objectForKey("offers_villages") as? [[String]]
    }
  }
  var regions: [[String]]? {
    set {
      NSUserDefaults.standardUserDefaults().setObject(newValue, forKey: "offers_regions")
    }
    get {
      return NSUserDefaults.standardUserDefaults().objectForKey("offers_regions") as? [[String]]
    }
  }
  
  class func sharedInstance() -> OffersManager {
    struct Shared {
      static let sharedInstance = OffersManager()
    }
    return Shared.sharedInstance
  }
  
  private init() {
    
  }
}
